/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor;

import java.util.ArrayList;
import java.util.HashMap;
import net.lucky_dip.hamleditor.editor.ColorManager;
import net.lucky_dip.hamleditor.editor.HamlCharacterPairMatcher;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public abstract class HamlesqueEditor
extends TextEditor {
    protected ColorManager colorManager;
    protected ProjectionAnnotationModel annotationModel;
    protected ProjectionSupport projectionSupport;
    protected Annotation[] oldAnnotations;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer pv = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(pv, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        pv.doOperation(19);
        this.annotationModel = pv.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer res = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        SourceViewerDecorationSupport svds = this.getSourceViewerDecorationSupport((ISourceViewer)res);
        svds.setCharacterPairMatcher((ICharacterPairMatcher)new HamlCharacterPairMatcher());
        svds.setMatchingCharacterPainterPreferenceKeys("rails.ui.editor.haml.char_matching", "rails.ui.editor.haml.char_matching.background");
        return res;
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public void updateFoldingStructure(ArrayList positions) {
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap newAnnotations = new HashMap();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }
}

