/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.lucky_dip.hamleditor.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HamlUIColorProvider {
    private static HamlUIColorProvider instance;
    private Map colorMap = new HashMap();

    private HamlUIColorProvider() {
    }

    public static HamlUIColorProvider getInstance() {
        if (instance == null) {
            instance = new HamlUIColorProvider();
        }
        return instance;
    }

    public void dispose() {
        Iterator i = this.colorMap.values().iterator();
        while (i.hasNext()) {
            ((Color)i.next()).dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colorMap.put(rgb, color);
        }
        return color;
    }

    public Color getColor(String rgb) {
        return this.getColor(StringConverter.asRGB((String)rgb));
    }

    public Color getColorFromPreference(String prefId) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)prefId);
        return this.getColor(rgb);
    }
}

