/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor;

import java.util.ArrayList;
import net.lucky_dip.hamleditor.HamlesqueBlock;
import net.lucky_dip.hamleditor.editor.HamlesqueEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;

public class HamlReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private HamlesqueEditor editor;
    private IDocument document;
    private int currentLine;
    private String[] lines;
    protected final ArrayList positions = new ArrayList();

    public HamlReconcilingStrategy(HamlesqueEditor editor) {
        this.editor = editor;
    }

    public void initialReconcile() {
        this.positions.clear();
        this.currentLine = 0;
        String template = this.document.get();
        this.lines = template.split("\\n");
        while (this.currentLine < this.lines.length) {
            Position p = this.getNextPosition();
            if (p == null) continue;
            this.positions.add(p);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                HamlReconcilingStrategy.this.editor.updateFoldingStructure(HamlReconcilingStrategy.this.positions);
            }
        });
    }

    private Position getNextPosition() {
        Position res = null;
        try {
            String line = this.lines[this.currentLine];
            if (line.trim().length() > 0) {
                int length;
                int start = this.document.getLineOffset(this.currentLine);
                if (start + (length = this.getNextPositionLength()) >= this.document.getLength()) {
                    length = this.document.getLength() - start;
                }
                if (length > 0) {
                    res = new Position(start, length);
                }
            } else {
                ++this.currentLine;
            }
        }
        catch (BadLocationException badLocationException) {
            res = null;
        }
        return res;
    }

    private int getNextPositionLength() throws BadLocationException {
        int res = 0;
        int lastLine = this.getLastLineInNextRegion();
        if (lastLine > this.currentLine && lastLine < this.lines.length) {
            int i = this.currentLine;
            while (i <= lastLine) {
                String trimmedLine = this.lines[i].trim();
                if (trimmedLine.length() > 0 || i < lastLine) {
                    res += this.document.getLineLength(i);
                }
                ++i;
            }
        }
        this.currentLine = lastLine + 1;
        return res;
    }

    private int getLastLineInNextRegion() {
        int res = this.currentLine;
        int startOffset = HamlesqueBlock.countIndentSpaces(this.lines[this.currentLine]);
        int i = this.currentLine + 1;
        while (i < this.lines.length) {
            int currentOffset = HamlesqueBlock.countIndentSpaces(this.lines[i]);
            String trimmedLine = this.lines[i].trim();
            if (currentOffset == startOffset && trimmedLine.length() > 0) break;
            if (currentOffset > startOffset || this.lines[i].trim().length() == 0) {
                ++res;
            }
            ++i;
        }
        if (res > this.currentLine && res < this.lines.length) {
            while (this.lines[res].trim().length() == 0) {
                --res;
            }
        }
        return res;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }
}

