/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.lucky_dip.hamleditor.editor.ColorManager;
import net.lucky_dip.hamleditor.editor.HamlEditor;
import net.lucky_dip.hamleditor.editor.HamlIndentLineAutoEditStrategy;
import net.lucky_dip.hamleditor.editor.HamlReconcilingStrategy;
import net.lucky_dip.hamleditor.editor.contentassist.HamlContentAssistantProcessor;
import net.lucky_dip.hamleditor.editor.scanners.DefaultScanner;
import net.lucky_dip.hamleditor.editor.scanners.HamlClassScanner;
import net.lucky_dip.hamleditor.editor.scanners.HamlCommentScanner;
import net.lucky_dip.hamleditor.editor.scanners.HamlDoctypeScanner;
import net.lucky_dip.hamleditor.editor.scanners.HamlElementScanner;
import net.lucky_dip.hamleditor.editor.scanners.HamlIDScanner;
import net.lucky_dip.hamleditor.editor.scanners.HamlPartitionScanner;
import net.lucky_dip.hamleditor.editor.scanners.RubyExpressionScanner;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.editors.text.TextEditor;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyTokenScanner;

public class HamlConfiguration
extends SourceViewerConfiguration {
    private HamlIndentLineAutoEditStrategy autoIndent;
    private HamlElementScanner elementScanner;
    private ColorManager colorManager;
    private HamlClassScanner classScanner;
    private HamlIDScanner idScanner;
    private HamlCommentScanner commentScanner;
    private HamlDoctypeScanner doctypeScanner;
    private AbstractRubyTokenScanner rubyScanner;
    private TextEditor editor;

    public HamlConfiguration(ColorManager colorManager, TextEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("__dftl_partition_content_type");
        types.addAll((Collection)Arrays.asList(HamlPartitionScanner.HAML_PARTITION_TYPES));
        return types.toArray(new String[0]);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__haml_partitioning";
    }

    protected HamlElementScanner getElementScanner() {
        if (this.elementScanner == null) {
            this.elementScanner = new HamlElementScanner(this.colorManager);
        }
        return this.elementScanner;
    }

    private HamlClassScanner getClassScanner() {
        if (this.classScanner == null) {
            this.classScanner = new HamlClassScanner(this.colorManager);
        }
        return this.classScanner;
    }

    private ITokenScanner getIDScanner() {
        if (this.idScanner == null) {
            this.idScanner = new HamlIDScanner(this.colorManager);
        }
        return this.idScanner;
    }

    private ITokenScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new HamlCommentScanner(this.colorManager);
        }
        return this.commentScanner;
    }

    private ITokenScanner getDoctypeScanner() {
        if (this.doctypeScanner == null) {
            this.doctypeScanner = new HamlDoctypeScanner(this.colorManager);
        }
        return this.doctypeScanner;
    }

    private ITokenScanner getRubyScanner() {
        if (this.rubyScanner == null) {
            this.rubyScanner = new RubyExpressionScanner();
        }
        return this.rubyScanner;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        HamlReconcilingStrategy strategy = new HamlReconcilingStrategy((HamlEditor)this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new DefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getElementScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__haml_element");
        reconciler.setRepairer((IPresentationRepairer)dr, "__haml_element");
        dr = new DefaultDamagerRepairer(this.getDoctypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__haml_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__haml_doctype");
        dr = new DefaultDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__haml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__haml_comment");
        dr = new DefaultDamagerRepairer(this.getIDScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__haml_id");
        reconciler.setRepairer((IPresentationRepairer)dr, "__haml_id");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getClassScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__haml_class");
        reconciler.setRepairer((IPresentationRepairer)dr, "__haml_class");
        dr = new DefaultDamagerRepairer(this.getRubyScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__haml_ruby");
        reconciler.setRepairer((IPresentationRepairer)dr, "__haml_ruby");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return "  ".length();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"  "};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.autoIndent == null) {
            this.autoIndent = new HamlIndentLineAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoIndent};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        ca.setDocumentPartitioning("__haml_partitioning");
        HamlContentAssistantProcessor pr = new HamlContentAssistantProcessor();
        ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__haml_class");
        ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__haml_element");
        ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__dftl_partition_content_type");
        ca.enableAutoActivation(true);
        ca.setAutoActivationDelay(500);
        ca.setProposalPopupOrientation(21);
        ca.setContextInformationPopupOrientation(21);
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }
}

