/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HamlesqueBlock {
    protected List<String> lines;

    public static int countIndentSpaces(String line) {
        int res = 0;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != ' ') break;
            ++res;
            ++i;
        }
        return res;
    }

    public HamlesqueBlock(String text) {
        this.lines = this.textToLines(text);
    }

    public HamlesqueBlock(String[] lines) {
        this.lines = Arrays.asList(lines);
    }

    public HamlesqueBlock[] getSubBlocks() {
        return this.getSubBlocks(0);
    }

    public String[] getLines() {
        return this.lines.toArray(new String[this.lines.size()]);
    }

    public HamlesqueBlock[] getSubBlocks(int startLine) {
        ArrayList<HamlesqueBlock> res = new ArrayList<HamlesqueBlock>();
        while (startLine < this.lines.size()) {
            if (this.isBlankLine(startLine)) {
                ++startLine;
                continue;
            }
            HamlesqueBlock nextBlock = this.getBlockStartingAt(startLine);
            startLine += nextBlock.getLines().length;
            res.add(nextBlock);
        }
        return res.toArray(new HamlesqueBlock[0]);
    }

    private HamlesqueBlock getBlockStartingAt(int startLine) {
        int initialOffset = HamlesqueBlock.countIndentSpaces(this.lines.get(startLine));
        int endLine = startLine + 1;
        while (endLine < this.lines.size()) {
            int currentOffset;
            if (!this.isBlankLine(endLine) && (currentOffset = HamlesqueBlock.countIndentSpaces(this.lines.get(endLine))) <= initialOffset) {
                --endLine;
                break;
            }
            ++endLine;
        }
        int i = endLine - 1;
        while (endLine > startLine) {
            if (!this.isBlankLine(i)) {
                endLine = i;
                break;
            }
            --i;
        }
        int length = endLine + 1 - startLine;
        String[] linesInBlock = new String[length];
        int x = 0;
        int i2 = startLine;
        while (i2 < endLine + 1) {
            linesInBlock[x++] = this.lines.get(i2);
            ++i2;
        }
        return new HamlesqueBlock(linesInBlock);
    }

    private boolean isBlankLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return false;
        }
        String line = this.lines.get(index);
        return line.trim().length() == 0;
    }

    protected List<String> textToLines(String text) {
        return Arrays.asList(text.split("\n"));
    }

    protected void addLine(int i, String line) {
        this.lines.add(i, line);
    }

    protected String removeLine(int i) {
        return this.lines.remove(i);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String line : this.lines) {
            sb.append(line);
            sb.append("\n");
        }
        if (!this.lines.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

