/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.radrails.db.core.DatabaseLog;
import org.radrails.db.core.QueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAdministrator {
    private Connection conn;
    private static final String ORACLE_BUG = "$";
    private static final String ORACLE_PROBLEM_CHECK = "oracle";

    public QueryAdministrator(Connection conn) {
        this.conn = conn;
    }

    private boolean isOracle() {
        if (this.conn == null) {
            return false;
        }
        return this.conn.getClass().getName().toLowerCase().indexOf(ORACLE_PROBLEM_CHECK) != -1;
    }

    private String getSchema() throws SQLException {
        if (this.conn == null) {
            return null;
        }
        if (this.isOracle()) {
            return this.conn.getMetaData().getUserName();
        }
        if (this.isDerby()) {
            return "APP";
        }
        return null;
    }

    private boolean isDerby() {
        if (this.conn == null) {
            return false;
        }
        return this.conn.getClass().getName().toLowerCase().indexOf("org.apache.derby") != -1;
    }

    private ResultSet executeQuery(String sql, int fetchSize) throws SQLException {
        PreparedStatement statement = null;
        statement = this.conn.prepareStatement(sql);
        statement.setFetchSize(fetchSize);
        statement.execute();
        try {
            return statement.getResultSet();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public Collection<String> getTables() {
        LinkedList<String> tables;
        block9: {
            tables = new LinkedList<String>();
            ResultSet rs = null;
            try {
                try {
                    rs = this.conn.getMetaData().getTables(null, this.getSchema(), null, null);
                    String table = "";
                    while (rs.next()) {
                        table = rs.getString(3);
                        if (this.isPotentialOracle10gProblem(table)) continue;
                        tables.add(table);
                    }
                }
                catch (SQLException e) {
                    DatabaseLog.logError((String)"Unable to get tables", (Throwable)e);
                    if (rs != null) {
                        this.closeResultSet(rs);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    this.closeResultSet(rs);
                }
                throw throwable;
            }
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
        return tables;
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                DatabaseLog.logError((String)"Unable to close result set!", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Collection<String> getColumns(String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isPotentialOracle10gProblem(String table) {
        return this.isOracle() && table.indexOf(ORACLE_BUG) != -1;
    }

    public boolean isPrimaryKey(String column, String table) {
        boolean retVal = false;
        if (!this.isOracle()) {
            try {
                DatabaseMetaData dbmd = this.conn.getMetaData();
                ResultSet pkrs = dbmd.getPrimaryKeys(null, null, table);
                while (pkrs.next()) {
                    if (!column.equals(pkrs.getString(4))) continue;
                    retVal = true;
                    break;
                }
            }
            catch (SQLException e) {
                DatabaseLog.logError((String)"Unable to get database metadata", (Throwable)e);
            }
        }
        return retVal;
    }

    public boolean isForeignKey(String column, String table) {
        boolean retVal = false;
        if (!this.isOracle()) {
            try {
                DatabaseMetaData dbmd = this.conn.getMetaData();
                ResultSet fkrs = dbmd.getImportedKeys(null, null, table);
                while (fkrs.next()) {
                    if (!column.equals(fkrs.getString(8))) continue;
                    retVal = true;
                    break;
                }
            }
            catch (SQLException e) {
                DatabaseLog.logError((String)"Unable to get database metadata", (Throwable)e);
            }
        }
        return retVal;
    }

    public QueryResult execute(String sql, int fetchSize) throws SQLException {
        LinkedList rows = new LinkedList();
        QueryResult result = null;
        ResultSet rs = this.executeQuery(sql, fetchSize);
        if (rs != null) {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            while (rs.next()) {
                LinkedList<Object> row = new LinkedList<Object>();
                i = 1;
                while (i <= colCount) {
                    Object o = rs.getObject(i);
                    if (o instanceof Integer && !rsmd.isSigned(i)) {
                        Integer integ = (Integer)o;
                        if (rsmd.getColumnType(i) == 5) {
                            row.add(new Integer(integ.shortValue()));
                        } else {
                            row.add(new Integer(integ));
                        }
                    } else if (o instanceof Long && !rsmd.isSigned(i)) {
                        Long lon = (Long)o;
                        row.add(new Long(lon.intValue()));
                    } else if (o instanceof Double && !rsmd.isSigned(i)) {
                        Double doub = (Double)o;
                        row.add(new Double(doub.intValue()));
                    } else if (o instanceof Short && !rsmd.isSigned(i)) {
                        Short shor = (Short)o;
                        row.add(new Integer(shor.intValue()));
                    } else {
                        row.add(o);
                    }
                    ++i;
                }
                rows.add(row);
            }
            LinkedList<String> columnNames = new LinkedList<String>();
            i = 1;
            while (i <= colCount) {
                columnNames.add(rsmd.getColumnName(i));
                ++i;
            }
            result = new QueryResult(columnNames, rows);
        } else {
            result = new QueryResult(new ArrayList(), new LinkedList());
        }
        return result;
    }

    public ResultSet executeRaw(String sql, int rowLimit) throws SQLException {
        return this.executeQuery(sql, 0);
    }

    public QueryResult execute(String sql) throws SQLException {
        return this.execute(sql, 0);
    }

    public void executeStatement(String sql) throws SQLException {
        PreparedStatement statement = null;
        statement = this.conn.prepareStatement(sql);
        statement.execute();
    }
}

