/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.radrails.db.core.DatabaseDescriptor;
import org.radrails.db.core.DatabaseLog;
import org.radrails.db.core.DatabaseManager;
import org.radrails.db.core.DatabaseYml;
import org.radrails.rails.core.RailsLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDatabaseManager
implements IResourceChangeListener {
    private IProject project;

    ProjectDatabaseManager(IProject project) {
        this.project = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    private IPath getDatabaseYMLPath() {
        return DatabaseYml.getPath(this.project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.resourcesChanged(event.getDelta(), 1);
    }

    private void resourcesChanged(IResourceDelta delta, int indent) {
        this.oneResourceChanged(delta, indent);
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.resourcesChanged(children[i], indent + 1);
            ++i;
        }
    }

    private void oneResourceChanged(IResourceDelta delta, int indent) {
        if (delta == null) {
            return;
        }
        IResource resource = delta.getResource();
        if (resource == null) {
            return;
        }
        String location = "";
        if (resource.getLocation() != null) {
            location = resource.getLocation().toString();
        }
        if (location.equals(this.getDatabaseYMLPath())) {
            DatabaseManager.getInstance().databaseChanged(resource.getProject());
        }
    }

    public Collection<DatabaseDescriptor> getDatabaseDescriptors() {
        try {
            DatabaseYml yml = DatabaseYml.create(this.project);
            return yml.getDescriptors();
        }
        catch (Exception e) {
            RailsLog.log((Exception)e);
            return Collections.emptyList();
        }
    }

    public Connection getConnection(String env) {
        Collection<DatabaseDescriptor> descriptors = this.getDatabaseDescriptors();
        for (DatabaseDescriptor databaseDescriptor : descriptors) {
            if (!databaseDescriptor.getName().equals(env)) continue;
            try {
                Class.forName(databaseDescriptor.getDriver());
                return DriverManager.getConnection(databaseDescriptor.getUrl());
            }
            catch (ClassNotFoundException e) {
                DatabaseLog.log((Exception)e);
            }
            catch (SQLException e) {
                DatabaseLog.log((Exception)e);
            }
        }
        return null;
    }
}

