/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jruby.util.ByteList;
import org.jvyamlb.YAML;
import org.radrails.db.core.DatabaseDescriptor;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseYml {
    private static Map<String, DatabaseYml> map = new HashMap<String, DatabaseYml>();
    private static Map<String, Long> timestamps = new HashMap<String, Long>();
    private Map<String, DatabaseDescriptor> fDescriptors;
    private File file;
    private IProject project;

    private DatabaseYml(File databaseYML, IProject project) {
        this.file = databaseYML;
        this.project = project;
    }

    public DatabaseDescriptor getDescriptor(String name) {
        return this.getDescriptorMap().get(name);
    }

    private synchronized Map<String, DatabaseDescriptor> getDescriptorMap() {
        block16: {
            if (this.fDescriptors == null) {
                if (!this.file.exists()) {
                    return null;
                }
                FileInputStream reader = null;
                try {
                    try {
                        reader = new FileInputStream(this.file);
                        this.fDescriptors = this.load(reader);
                    }
                    catch (Exception e) {
                        RailsLog.log((Exception)e);
                        try {
                            if (reader != null) {
                                ((InputStream)reader).close();
                            }
                            break block16;
                        }
                        catch (IOException iOException) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            ((InputStream)reader).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        ((InputStream)reader).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return this.fDescriptors;
    }

    public Collection<DatabaseDescriptor> getDescriptors() {
        if (this.getDescriptorMap() == null) {
            return Collections.emptySet();
        }
        return this.getDescriptorMap().values();
    }

    private Map<String, DatabaseDescriptor> load(InputStream stream) throws IOException {
        HashMap<String, DatabaseDescriptor> descriptors = new HashMap<String, DatabaseDescriptor>();
        Map configuration = (Map)YAML.load((InputStream)stream);
        for (Map.Entry entry : configuration.entrySet()) {
            DatabaseDescriptor desc = new DatabaseDescriptor(((ByteList)entry.getKey()).toString(), this.project);
            Object children = entry.getValue();
            if (children instanceof Map) {
                Map subNodes = (Map)children;
                for (Map.Entry subEntry : subNodes.entrySet()) {
                    if (subEntry == null || subEntry.getKey() == null || subEntry.getValue() instanceof Map) continue;
                    String value = "";
                    if (subEntry.getValue() != null) {
                        value = subEntry.getValue().toString();
                    }
                    this.dbMapping(desc, ((ByteList)subEntry.getKey()).toString(), value);
                }
            }
            descriptors.put(desc.getName(), desc);
        }
        return descriptors;
    }

    private void dbMapping(DatabaseDescriptor descriptor, String key, String value) {
        if (descriptor == null) {
            return;
        }
        if (key.equals("adapter")) {
            descriptor.setAdapter(value);
        } else if (key.equals("database")) {
            descriptor.setDatabase(value);
        } else if (key.equals("host")) {
            descriptor.setHost(value);
        } else if (key.equals("username")) {
            descriptor.setUsername(value);
        } else if (key.equals("password")) {
            descriptor.setPassword(value);
        } else if (key.equals("port")) {
            descriptor.setPort(value);
        } else if (key.equals("sslcert")) {
            descriptor.setSSLCert(value);
        } else if (key.equals("sslcapath")) {
            descriptor.setSSLCapath(value);
        } else if (key.equals("sslcipher")) {
            descriptor.setSSLCipher(value);
        } else if (key.equals("socket")) {
            descriptor.setSocket(value);
        } else if (key.equals("sslkey")) {
            descriptor.setSSLKey(value);
        } else if (key.equals("schema_order")) {
            descriptor.setSchemaOrder(value);
        } else if (key.equals("dbfile")) {
            descriptor.setDBFile(value);
        } else if (key.equals("url")) {
            descriptor.setURL(value);
        } else if (key.equals("driver")) {
            descriptor.setDriver(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseYml create(IProject project) {
        IProject iProject = project;
        synchronized (iProject) {
            return DatabaseYml.create(DatabaseYml.getPath(project).toFile(), project);
        }
    }

    private static DatabaseYml create(File databaseYML, IProject project) {
        Long timestamp;
        if (map.containsKey(databaseYML.getAbsolutePath())) {
            Long cachedTimestamp = timestamps.get(databaseYML.getAbsolutePath());
            timestamp = databaseYML.lastModified();
            if (timestamp.equals(cachedTimestamp)) {
                return map.get(databaseYML.getAbsolutePath());
            }
        }
        DatabaseYml yml = new DatabaseYml(databaseYML, project);
        map.put(databaseYML.getAbsolutePath(), yml);
        timestamp = databaseYML.lastModified();
        timestamps.put(databaseYML.getAbsolutePath(), timestamp);
        return yml;
    }

    static IPath getPath(IProject project) {
        if (project == null) {
            return Path.EMPTY;
        }
        IPath root = RailsPlugin.findRailsRoot((IProject)project);
        if (root == null) {
            root = Path.EMPTY;
        }
        if (project.getLocation() == null) {
            return Path.EMPTY;
        }
        return project.getLocation().append(root).append("config").append("database.yml");
    }

    public boolean setDescriptor(String environment, DatabaseDescriptor desc) {
        if (!this.file.exists()) {
            return false;
        }
        StringBuilder modified = new StringBuilder();
        BufferedReader reader = null;
        boolean inDesignatedEnvironment = false;
        try {
            try {
                reader = new BufferedReader(new FileReader(this.file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(String.valueOf(environment) + ":")) {
                        inDesignatedEnvironment = true;
                        modified.append(desc.toYML());
                        continue;
                    }
                    if (inDesignatedEnvironment && !Character.isWhitespace(line.charAt(0))) {
                        inDesignatedEnvironment = false;
                    }
                    if (inDesignatedEnvironment) continue;
                    modified.append(line).append("\n");
                }
            }
            catch (Exception e) {
                RailsLog.log((Exception)e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        Writer writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(this.file));
                writer.write(modified.toString());
            }
            catch (IOException e) {
                RailsLog.log((Exception)e);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
        return true;
    }
}

