/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.MisconfigurationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private static MessageConsole fConsole;
    private static IOConsoleOutputStream fOutputStream;
    private static final Object lock;
    private static final StringBuffer logIndent;

    static {
        lock = new Object();
        logIndent = new StringBuffer();
    }

    public static void log(int errorLevel, String message, Throwable e) {
        System.err.println(message);
        if (e != null && !(e instanceof MisconfigurationException)) {
            e.printStackTrace();
        }
        try {
            Status s = new Status(errorLevel, CorePlugin.getPluginID(), errorLevel, message, e);
            CorePlugin.getDefault().getLog().log((IStatus)s);
        }
        catch (Exception exception) {}
    }

    public static void log(Throwable e) {
        Log.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten (null message).", e);
    }

    public static void log(String msg) {
        Log.log(4, msg, new RuntimeException(msg));
    }

    public static void log(String msg, Throwable e) {
        Log.log(4, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toLogFile(Object obj, String string) {
        Object object = lock;
        synchronized (object) {
            if (obj == null) {
                obj = new Object();
            }
            Class<?> class1 = obj.getClass();
            Log.toLogFile(string, class1);
        }
    }

    public static void toLogFile(String string, Class<? extends Object> class1) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(logIndent);
        buffer.append(FullRepIterable.getLastPart(class1.getName()));
        buffer.append(": ");
        buffer.append(string);
        Log.toLogFile(buffer.toString());
    }

    private static void toLogFile(final String buffer) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    try {
                        CorePlugin default1 = CorePlugin.getDefault();
                        if (default1 == null) {
                            System.out.println(buffer);
                            return;
                        }
                        System.out.println(buffer);
                        IOConsoleOutputStream c = Log.getConsoleOutputStream();
                        c.write(buffer.toString());
                        c.write("\r\n");
                    }
                    catch (Throwable e) {
                        Log.log(e);
                    }
                }
            }
        };
        Display current = Display.getCurrent();
        if (current != null && current.getThread() == Thread.currentThread()) {
            r.run();
        } else if (current == null) {
            current = Display.getDefault();
            current.asyncExec(r);
        }
    }

    private static IOConsoleOutputStream getConsoleOutputStream() {
        if (fConsole == null) {
            fConsole = new MessageConsole("Pydev Logging", CorePlugin.getImageCache().getDescriptor("icons/python_logging.png"));
            fOutputStream = fConsole.newOutputStream();
            HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
            themeConsoleStreamToColor.put(fOutputStream, "console.output");
            fConsole.setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
        }
        return fOutputStream;
    }

    public static void toLogFile(Exception e) {
        String msg = Log.getExceptionStr(e);
        Log.toLogFile(msg);
    }

    public static String getExceptionStr(Exception e) {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        PrintStream prnt = new PrintStream(str);
        e.printStackTrace(prnt);
        prnt.flush();
        String msg = new String(str.toByteArray());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogLevel() {
        Object object = lock;
        synchronized (object) {
            logIndent.append("    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remLogLevel() {
        Object object = lock;
        synchronized (object) {
            if (logIndent.length() > 3) {
                logIndent.delete(0, 4);
            }
        }
    }
}

