/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import com.rc.retroweaver.runtime.Autobox;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.ui.console.IConsoleFactory;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.env.IProcessFactory;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.ScriptConsoleManager;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        this.createConsole();
    }

    public PydevConsole createConsole() {
        try {
            return this.createConsole(PydevConsoleFactory.createDefaultPydevInterpreter(), null);
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
            return null;
        }
    }

    public PydevConsole createConsole(String additionalInitialComands) {
        try {
            return this.createConsole(PydevConsoleFactory.createDefaultPydevInterpreter(), additionalInitialComands);
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
            return null;
        }
    }

    public PydevConsole createConsole(PydevConsoleInterpreter interpreter, String additionalInitialComands) {
        ScriptConsoleManager manager = ScriptConsoleManager.getInstance();
        try {
            if (interpreter != null) {
                PydevConsole console = new PydevConsole(interpreter, additionalInitialComands);
                manager.add((ScriptConsole)console, true);
                return console;
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
        }
        return null;
    }

    public static PydevConsoleInterpreter createDefaultPydevInterpreter() throws Exception, UserCanceledException {
        IProcessFactory iprocessFactory = new IProcessFactory();
        IProcessFactory.PydevConsoleLaunchInfo launchAndProcess = iprocessFactory.createInteractiveLaunch();
        if (launchAndProcess == null) {
            return null;
        }
        return PydevConsoleFactory.createPydevInterpreter(launchAndProcess, iprocessFactory.getNaturesUsed());
    }

    public static PydevConsoleInterpreter createPydevInterpreter(IProcessFactory.PydevConsoleLaunchInfo info, List<IPythonNature> natures) throws Exception {
        Launch launch = info.launch;
        Process process = info.process;
        Integer clientPort = Autobox.valueOf((int)info.clientPort);
        IInterpreterInfo interpreterInfo = info.interpreter;
        if (launch == null) {
            return null;
        }
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        int port = Integer.parseInt(launch.getAttribute("INTERACTIVE_LAUNCH_PORT"));
        consoleInterpreter.setConsoleCommunication(new PydevConsoleCommunication(port, process, clientPort));
        consoleInterpreter.setNaturesUsed(natures);
        consoleInterpreter.setInterpreterInfo(interpreterInfo);
        PydevDebugPlugin.getDefault().addConsoleLaunch((ILaunch)launch);
        consoleInterpreter.addCloseOperation(new Runnable((ILaunch)launch){
            private final /* synthetic */ ILaunch val$launch;
            {
                this.val$launch = iLaunch;
            }

            public void run() {
                PydevDebugPlugin.getDefault().removeConsoleLaunch(this.val$launch);
            }
        });
        return consoleInterpreter;
    }
}

