/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleIronpythonRunner;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IronpythonInterpreterManager
extends AbstractInterpreterManager {
    public IronpythonInterpreterManager(Preferences prefs) {
        super(prefs);
    }

    @Override
    protected String getPreferenceName() {
        return "IRONPYTHON_INTERPRETER_PATH";
    }

    @Override
    protected String getNotConfiguredInterpreterMsg() {
        return "Interpreter is not properly configured!\nPlease go to window > preferences > PyDev > Iron Python Interpreters and configure it.\nIf this is not supposed to be an Iron Python project, change the project type on the\nproject properties to the project you want (e.g.: Python project).";
    }

    @Override
    public Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String executable, IProgressMonitor monitor) throws CoreException {
        return IronpythonInterpreterManager.doCreateInterpreterInfo(executable, monitor);
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor) throws CoreException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (isJythonExecutable) {
            throw new RuntimeException("A jar cannot be used in order to get the info for the iron python interpreter.");
        }
        File script = PydevPlugin.getScriptWithinPySrc("interpreterInfo.py");
        Tuple<String, String> outTup = new SimpleIronpythonRunner().runAndGetOutputWithInterpreter(executable, REF.getFileAbsolutePath((File)script), null, null, null, monitor);
        InterpreterInfo info = IronpythonInterpreterManager.createInfoFromOutput(monitor, outTup);
        if (info == null) {
            return null;
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)((String)outTup.o1));
    }

    public int getInterpreterType() {
        return 2;
    }

    public String getManagerRelatedName() {
        return "ironpython";
    }
}

