/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.logging.ping;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.ping.ILogPing;
import org.python.pydev.logging.ping.ILogPingProvider;
import org.python.pydev.logging.ping.ILogPingSender;
import org.python.pydev.logging.ping.LogInfoProvider;
import org.python.pydev.logging.ping.LogPingSender;

public class SynchedLogPing
implements ILogPing {
    private File location;
    private OutputStream bufferedOutputStream;
    private final List<String> keyValueContents = new ArrayList<String>();
    private ILogPingProvider provider;
    public ILogPingSender sender;
    private FileOutputStream stream;
    private static Object lock = new Object();

    public SynchedLogPing(String location) {
        this(location, new LogInfoProvider(), new LogPingSender());
    }

    public SynchedLogPing(String location, ILogPingProvider provider, ILogPingSender sender) {
        this.provider = provider;
        this.sender = sender;
        this.location = new File(location);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = lock;
        synchronized (object) {
            if (this.location.exists()) {
                String fileContents;
                try {
                    fileContents = REF.getFileContents((File)this.location);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    fileContents = "";
                }
                if (fileContents.length() > 0x100000) {
                    try {
                        this.location.delete();
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                List fileLines = StringUtils.split((String)fileContents, (char)'\n');
                this.keyValueContents.addAll(fileLines);
            }
            try {
                this.stream = new FileOutputStream(this.location, true);
                this.bufferedOutputStream = new BufferedOutputStream(this.stream);
            }
            catch (Exception e) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
                Log.log((Throwable)e);
                this.bufferedOutputStream = new OutputStream(){

                    public void write(int b) throws IOException {
                    }
                };
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingOpenEditor() {
        Object object = lock;
        synchronized (object) {
            String message = this.createPingOpenEditorEncodedMessage();
            this.addEncodedMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingStartPlugin() {
        Object object = lock;
        synchronized (object) {
            String message = this.createPingStartPluginEncodedMessage();
            this.addEncodedMessage(message);
        }
    }

    String createPingOpenEditorEncodedMessage() {
        return this.createEncodedMessage("editor.opened", "PydevEditor_2.0.0.2011040403");
    }

    String createPingStartPluginEncodedMessage() {
        return this.createEncodedMessage("plugin.started", "Pydev_2.0.0.2011040403");
    }

    String createEncodedMessage(String key, String val) {
        return StringUtils.urlEncodeKeyValuePair((String)(String.valueOf(key) + "[]"), (String)(String.valueOf(this.provider.getCurrentTime()) + ":" + val));
    }

    void addEncodedMessage(String urlEncodeKeyValuePair) {
        if (urlEncodeKeyValuePair != null) {
            this.keyValueContents.add(urlEncodeKeyValuePair);
            try {
                this.bufferedOutputStream.write(urlEncodeKeyValuePair.getBytes());
                this.bufferedOutputStream.write("\n".getBytes());
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = lock;
        synchronized (object) {
            this.stop();
            try {
                this.location.delete();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getContentsToSend() {
        Object object = lock;
        synchronized (object) {
            if (this.keyValueContents.size() > 0) {
                return "id=" + this.provider.getApplicationId() + "&" + StringUtils.join((String)"&", this.keyValueContents);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        Object object = lock;
        synchronized (object) {
            String contentsToSend = this.getContentsToSend();
            if (this.sender.sendPing(contentsToSend)) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = lock;
        synchronized (object) {
            this.keyValueContents.clear();
            try {
                this.bufferedOutputStream.flush();
            }
            catch (IOException iOException) {}
            try {
                this.bufferedOutputStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.stream.close();
            }
            catch (IOException iOException) {}
            this.bufferedOutputStream = new OutputStream(){

                public void write(int b) throws IOException {
                }
            };
        }
    }
}

