/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.logging.ping;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.zip.GZIPOutputStream;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.ping.ILogPingSender;

public class LogPingSender
implements ILogPingSender {
    private static final String UPDATE_URL = "https://ping.aptana.com/ping.php";

    public boolean sendPing(String pingString) {
        URL url = null;
        boolean result = false;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            try {
                gos.write(pingString.getBytes());
                gos.flush();
                gos.finish();
            }
            finally {
                gos.close();
            }
            baos.close();
            byte[] gzippedData = baos.toByteArray();
            url = new URL(UPDATE_URL);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.setRequestProperty("Content-Length", String.valueOf(gzippedData.length));
            connection.setRequestProperty("User-Agent", "Pydev/2.0.0.2011040403");
            try {
                connection.setReadTimeout(60000);
            }
            catch (Throwable throwable) {}
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            try {
                output.write(gzippedData);
                output.flush();
                BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    String line;
                    StringBuffer sb = new StringBuffer();
                    while ((line = input.readLine()) != null) {
                        sb.append(line);
                    }
                }
                finally {
                    input.close();
                }
            }
            finally {
                output.close();
            }
            result = true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return result;
    }
}

