/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssistSurroundWith
extends AbstractTemplateCodeCompletion
implements IAssistProps {
    public static final String[] SURROUND_WITH_COMPLETIONS = new String[]{"%stry:%s%s%s%sexcept${cursor}:%s%s%sraise", "try..except", "%stry:%s%s%s%sexcept (${RuntimeError}, ), e:%s%s%s${raise}${cursor}", "try..except (RuntimeError, ), e", "%stry:%s%s%s%sfinally:%s%s%s${pass}", "try..finally", "%sif ${True}:%s%s%s%selse:%s%s%s${pass}", "if..else", "%swhile ${True}:%s%s%s%s%s", "while", "%sfor ${item} in ${collection}:%s%s%s%s%s${cursor}", "for", "%sif ${True}:%s%s%s%s%s${cursor}", "if", "%swith ${var}:%s%s%s%s%s${cursor}", "with"};

    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        String indentation = PyAction.getStaticIndentationString(edit);
        ps.selectCompleteLine();
        String selectedText = ps.getSelectedText();
        List splitInLines = StringUtils.splitInLines((String)selectedText);
        int firstCharPosition = -1;
        for (String string : splitInLines) {
            if (string.trim().length() <= 0) continue;
            int localFirst = PySelection.getFirstCharPosition((String)string);
            if (firstCharPosition == -1) {
                firstCharPosition = localFirst;
                continue;
            }
            if (localFirst >= firstCharPosition) continue;
            firstCharPosition = localFirst;
        }
        if (firstCharPosition == -1) {
            return l;
        }
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        FastStringBuffer startIndentBuffer = new FastStringBuffer(firstCharPosition + 1);
        startIndentBuffer.appendN(' ', firstCharPosition);
        String startIndent = startIndentBuffer.toString();
        String surroundedCode = selectedText;
        surroundedCode = new StringBuffer(String.valueOf(indentation)).append(surroundedCode.replaceAll(delimiter, new StringBuffer(String.valueOf(delimiter)).append(indentation).toString())).toString();
        IRegion region = ps.getRegion();
        TemplateContext context = null;
        if (edit != null) {
            context = this.createContext((ITextViewer)edit.getPySourceViewer(), region, ps.getDoc());
        }
        Object[] replace0to3 = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, delimiter, startIndent, indentation, indentation};
        Object[] replace4toEnd = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, indentation};
        int iComp = 0;
        int iRep = 0;
        while (iComp < SURROUND_WITH_COMPLETIONS.length) {
            String comp = SURROUND_WITH_COMPLETIONS[iComp];
            comp = iRep < 4 ? StringUtils.format((String)comp, (Object[])replace0to3) : StringUtils.format((String)comp, (Object[])replace4toEnd);
            l.add(this.createProposal(ps, imageCache, edit, startIndent, region, iComp, comp, context));
            iComp += 2;
            ++iRep;
        }
        return l;
    }

    private ICompletionProposal createProposal(PySelection ps, ImageCache imageCache, PyEdit edit, final String startIndent, IRegion region, int iComp, String comp, TemplateContext context) {
        Template t = new Template("Surround with", SURROUND_WITH_COMPLETIONS[iComp + 1], "", comp, false);
        if (context != null) {
            TemplateProposal proposal = new TemplateProposal(t, context, region, imageCache.get("icons/template.gif"), 5){

                public String getAdditionalProposalInfo() {
                    return String.valueOf(startIndent) + super.getAdditionalProposalInfo();
                }
            };
            return proposal;
        }
        return new CompletionProposal(comp, region.getOffset(), region.getLength(), 0);
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return ps.getTextSelection().getLength() > 0;
    }

    @Override
    public List<Object> getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException {
        throw new RuntimeException("Not implemented: completions should be gotten from the IAssistProps interface.");
    }
}

