/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;

public abstract class AbstractIndentPrefs
implements IIndentPrefs {
    private boolean forceTabs = false;

    public boolean getForceTabs() {
        return this.forceTabs;
    }

    public void setForceTabs(boolean forceTabs) {
        this.forceTabs = forceTabs;
    }

    public String getIndentationString() {
        if (this.getUseSpaces(true)) {
            return StringUtils.createSpaceString((int)this.getTabWidth());
        }
        return "\t";
    }

    public void convertToStd(IDocument document, DocumentCommand command) {
        try {
            command.text = this.getUseSpaces(true) ? this.convertTabsToSpaces(document, command.text, command.offset, this.getIndentationString()) : this.convertSpacesToTabs(document, command.text, command.offset, this.getIndentationString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String convertTabsToSpaces(IDocument document, String text, int offset, String indentString) throws BadLocationException {
        if (text.indexOf("\t") != -1) {
            if (text.equals("\t")) {
                this.deleteWhitespaceAfter(document, offset);
                text = indentString;
            } else {
                char[] chars = text.toCharArray();
                FastStringBuffer newText = new FastStringBuffer();
                int count = 0;
                while (count < chars.length) {
                    if (chars[count] == '\t') {
                        newText.append(indentString);
                    } else {
                        newText.append(chars[count]);
                    }
                    ++count;
                }
                text = newText.toString();
            }
        }
        return text;
    }

    private String convertSpacesToTabs(IDocument document, String text, int offset, String indentString) throws BadLocationException {
        String spaceStr = StringUtils.createSpaceString((int)this.getTabWidth());
        while (text.startsWith(spaceStr)) {
            text = text.replaceAll(spaceStr, "\t");
        }
        return text;
    }

    private void deleteWhitespaceAfter(IDocument document, int offset) throws BadLocationException {
        if (offset < document.getLength() && !AbstractIndentPrefs.endsWithNewline(document, document.get(offset, 1))) {
            int lineLength = document.getLineInformationOfOffset(offset).getLength();
            int lineStart = document.getLineInformationOfOffset(offset).getOffset();
            String textAfter = document.get(offset, lineStart + lineLength - offset);
            if (textAfter.length() > 0 && this.isWhitespace(textAfter)) {
                document.replace(offset, textAfter.length(), "");
            }
        }
    }

    private boolean isWhitespace(String s) {
        int len = s.length();
        int i = len - 1;
        while (i > -1) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean endsWithNewline(IDocument document, String text) {
        String[] newlines = document.getLegalLineDelimiters();
        boolean ends = false;
        int i = 0;
        while (i < newlines.length) {
            String delimiter = newlines[i];
            if (text.indexOf(delimiter) != -1) {
                ends = true;
            }
            ++i;
        }
        return ends;
    }
}

