/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import com.rc.retroweaver.runtime.Autobox;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlockCommentAction
extends PyAction {
    protected boolean alignRight = true;
    protected int defaultCols = 80;

    public abstract int perform(PySelection var1);

    protected abstract String getPreferencesNameForChar();

    public AbstractBlockCommentAction() {
    }

    protected AbstractBlockCommentAction(int defaultCols, boolean alignLeft) {
        this.defaultCols = defaultCols;
        this.alignRight = alignLeft;
    }

    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PySelection ps = new PySelection(this.getTextEditor());
            int toSelect = this.perform(ps);
            if (toSelect != -1) {
                this.getTextEditor().selectAndReveal(toSelect, 0);
            } else {
                this.revealSelEndLine(ps);
            }
        }
        catch (Exception e) {
            AbstractBlockCommentAction.beep(e);
        }
    }

    public Tuple<Integer, Character> getColsAndChar() {
        int cols = this.defaultCols;
        char c = '-';
        try {
            IPreferenceStore chainedPrefStore = PydevPrefs.getChainedPrefStore();
            cols = chainedPrefStore.getInt("printMarginColumn");
            Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
            c = prefs.getString(this.getPreferencesNameForChar()).charAt(0);
        }
        catch (NullPointerException nullPointerException) {}
        return new Tuple((Object)Autobox.valueOf((int)cols), (Object)Autobox.valueOf((char)c));
    }

    public int getEditorTabWidth() {
        try {
            IPreferenceStore chainedPrefStore = PydevPrefs.getChainedPrefStore();
            return chainedPrefStore.getInt("tabWidth");
        }
        catch (NullPointerException nullPointerException) {
            return 4;
        }
    }

    protected int getLenOfStrConsideringTabEditorLen(String str) {
        int ret = 0;
        int tabWidth = this.getEditorTabWidth();
        int i = 0;
        while (i < str.length()) {
            ret = str.charAt(i) == '\t' ? (ret += tabWidth) : ++ret;
            ++i;
        }
        return ret;
    }
}

