/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.analysis.ctrl_1.AbstractAnalysisMarkersParticipants;
import com.python.pydev.refactoring.tdd.PyCreateMethodOrField;
import com.python.pydev.refactoring.tdd.TddQuickFixParticipant;
import com.python.pydev.refactoring.tdd.TddRefactorCompletion;
import com.python.pydev.refactoring.tdd.TddRefactorCompletionInModule;
import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TddCodeGenerationQuickFixParticipant
extends AbstractAnalysisMarkersParticipants {
    private TddQuickFixParticipant tddQuickFixParticipant;

    protected void fillParticipants() {
        this.tddQuickFixParticipant = new TddQuickFixParticipant();
        this.participants.add(this.tddQuickFixParticipant);
    }

    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        List ret = super.getProps(ps, imageCache, f, nature, edit, offset);
        int lineOfOffset = ps.getLineOfOffset(offset);
        String lineContents = ps.getLine(lineOfOffset);
        List callsAtLine = ps.getTddPossibleMatchesAtLine();
        if (callsAtLine.size() > 0) {
            HashMap<String, PySelection.TddPossibleMatches> callsToCheck = new HashMap<String, PySelection.TddPossibleMatches>();
            for (PySelection.TddPossibleMatches tddPossibleMatches : callsAtLine) {
                String callString = new StringBuffer(String.valueOf(tddPossibleMatches.initialPart)).append(tddPossibleMatches.secondPart).toString();
                callsToCheck.put(callString, tddPossibleMatches);
            }
            for (Map.Entry entry : callsToCheck.entrySet()) {
                IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
                try {
                    PySelection.TddPossibleMatches possibleMatch = (PySelection.TddPossibleMatches)entry.getValue();
                    String full = possibleMatch.full;
                    String callWithoutParens = (String)entry.getKey();
                    int indexOf = lineContents.indexOf(full);
                    if (indexOf < 0) {
                        Log.log((String)"Did not expect index < 0.");
                        continue;
                    }
                    PySelection callPs = new PySelection(ps.getDoc(), ps.getLineOffset() + indexOf + callWithoutParens.length());
                    RefactoringRequest request = new RefactoringRequest(edit, callPs);
                    request.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)Autobox.valueOf((boolean)false));
                    ItemPointer[] pointers = pyRefactoring.findDefinition(request);
                    if (possibleMatch.isCall && pointers.length >= 1) {
                        this.checkInitCreation(edit, callPs, pointers, ret);
                        continue;
                    }
                    if (pointers.length == 0) {
                        this.checkMethodCreationAtClass(edit, pyRefactoring, callWithoutParens, callPs, ret, lineContents, possibleMatch);
                        continue;
                    }
                    if (possibleMatch.isCall) continue;
                    boolean foundInInit = false;
                    ItemPointer[] itemPointerArray = pointers;
                    int n = pointers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemPointer p = itemPointerArray[n2];
                        Definition definition = p.definition;
                        try {
                            FunctionDef functionDef;
                            String rep;
                            Object peek = definition.scope.getScopeStack().peek();
                            if (peek instanceof FunctionDef && (rep = NodeUtils.getRepresentationString((SimpleNode)(functionDef = (FunctionDef)peek))) != null && rep.equals("__init__")) {
                                foundInInit = true;
                                break;
                            }
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                    if (foundInInit) continue;
                    this.checkMethodCreationAtClass(edit, pyRefactoring, callWithoutParens, callPs, ret, lineContents, possibleMatch);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return ret;
    }

    private boolean checkMethodCreationAtClass(PyEdit edit, IPyRefactoring pyRefactoring, String callWithoutParens, PySelection callPs, List<ICompletionProposal> ret, String lineContents, PySelection.TddPossibleMatches possibleMatch) throws MisconfigurationException, Exception {
        block9: {
            String[] headAndTail = FullRepIterable.headAndTail((String)callWithoutParens);
            if (headAndTail[0].length() <= 0) break block9;
            String methodToCreate = headAndTail[1];
            if (headAndTail[0].equals("self")) {
                int firstCharPosition = PySelection.getFirstCharPosition((String)lineContents);
                PySelection.LineStartingScope scopeStart = callPs.getPreviousLineThatStartsScope(PySelection.CLASS_TOKEN, false, firstCharPosition);
                String classNameInLine = null;
                if (scopeStart != null) {
                    PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                    List<String> parametersAfterCall = null;
                    parametersAfterCall = this.configCreateAsAndReturnParaetersAfterCall(callPs, possibleMatch, pyCreateMethod, parametersAfterCall, methodToCreate);
                    String startingScopeLineContents = callPs.getLine(scopeStart.iLineStartingScope);
                    classNameInLine = PySelection.getClassNameInLine((String)startingScopeLineContents);
                    if (classNameInLine != null && classNameInLine.length() > 0) {
                        pyCreateMethod.setCreateInClass(classNameInLine);
                        this.addCreateMethodOption(callPs, edit, ret, methodToCreate, parametersAfterCall, pyCreateMethod, classNameInLine);
                    }
                }
                return true;
            }
            int absoluteCursorOffset = callPs.getAbsoluteCursorOffset();
            PySelection newSelection = new PySelection(callPs.getDoc(), absoluteCursorOffset -= 1 + methodToCreate.length());
            RefactoringRequest request = new RefactoringRequest(edit, newSelection);
            request.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)Autobox.valueOf((boolean)false));
            ItemPointer[] pointers = pyRefactoring.findDefinition(request);
            if (pointers.length != 1) break block9;
            ItemPointer[] itemPointerArray = pointers;
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    Definition definition;
                    block10: {
                        ItemPointer pointer = itemPointerArray[n2];
                        definition = pointer.definition;
                        if (!(definition instanceof AssignDefinition)) break block10;
                        AssignDefinition assignDef = (AssignDefinition)definition;
                        if (assignDef.value.equals("None")) break block11;
                        IPythonNature nature = edit.getPythonNature();
                        IDefinition[] definitions2 = assignDef.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)assignDef.value, (IPythonNature)nature, (ICompletionCache)new CompletionCache()), assignDef.line, assignDef.col, nature);
                        if (definitions2.length == 1) {
                            definition = (Definition)definitions2[0];
                        }
                    }
                    if (definition != null && definition.ast instanceof ClassDef) {
                        ClassDef d = (ClassDef)definition.ast;
                        PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                        List<String> parametersAfterCall = null;
                        parametersAfterCall = this.configCreateAsAndReturnParaetersAfterCall(callPs, possibleMatch, pyCreateMethod, parametersAfterCall, methodToCreate);
                        String className = NodeUtils.getRepresentationString((SimpleNode)d);
                        pyCreateMethod.setCreateInClass(className);
                        String displayString = StringUtils.format((String)"Create %s %s at %s (%s)", (Object[])new Object[]{methodToCreate, pyCreateMethod.getCreationStr(), className, definition.module.getName()});
                        TddRefactorCompletionInModule completion = new TddRefactorCompletionInModule(methodToCreate, this.tddQuickFixParticipant.imageMethod, displayString, null, displayString, 5, edit, definition.module.getFile(), parametersAfterCall, pyCreateMethod, newSelection);
                        completion.locationStrategy = 1;
                        ret.add((ICompletionProposal)completion);
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private List<String> configCreateAsAndReturnParaetersAfterCall(PySelection callPs, PySelection.TddPossibleMatches possibleMatch, PyCreateMethodOrField pyCreateMethod, List<String> parametersAfterCall, String methodToCreate) {
        if (possibleMatch.isCall) {
            pyCreateMethod.setCreateAs(0);
            parametersAfterCall = callPs.getParametersAfterCall(callPs.getAbsoluteCursorOffset());
        } else if (StringUtils.isAllUpper((String)methodToCreate)) {
            pyCreateMethod.setCreateAs(4);
        } else {
            pyCreateMethod.setCreateAs(3);
        }
        return parametersAfterCall;
    }

    private void addCreateMethodOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall, PyCreateMethodOrField pyCreateMethod, String classNameInLine) {
        String displayString = StringUtils.format((String)"Create %s %s at %s", (Object[])new Object[]{markerContents, pyCreateMethod.getCreationStr(), classNameInLine});
        TddRefactorCompletion tddRefactorCompletion = new TddRefactorCompletion(markerContents, this.tddQuickFixParticipant.imageMethod, displayString, null, null, 5, edit, 0, parametersAfterCall, pyCreateMethod, ps);
        props.add((ICompletionProposal)tddRefactorCompletion);
    }

    private boolean checkInitCreation(PyEdit edit, PySelection callPs, ItemPointer[] pointers, List<ICompletionProposal> ret) {
        ItemPointer[] itemPointerArray = pointers;
        int n = pointers.length;
        int n2 = 0;
        while (n2 < n) {
            ClassDef d;
            ASTEntry initEntry;
            ItemPointer pointer = itemPointerArray[n2];
            Definition definition = pointer.definition;
            if (definition != null && definition.ast instanceof ClassDef && (initEntry = TddCodeGenerationQuickFixParticipant.findInitInClass(d = (ClassDef)definition.ast)) == null) {
                PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                pyCreateMethod.setCreateAs(0);
                String className = NodeUtils.getRepresentationString((SimpleNode)d);
                pyCreateMethod.setCreateInClass(className);
                List parametersAfterCall = callPs.getParametersAfterCall(callPs.getAbsoluteCursorOffset());
                String displayString = StringUtils.format((String)"Create %s __init__ (%s)", (Object[])new Object[]{className, definition.module.getName()});
                TddRefactorCompletionInModule completion = new TddRefactorCompletionInModule("__init__", this.tddQuickFixParticipant.imageMethod, displayString, null, displayString, 5, edit, definition.module.getFile(), parametersAfterCall, pyCreateMethod, callPs);
                completion.locationStrategy = 2;
                ret.add((ICompletionProposal)completion);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ASTEntry findInitInClass(ClassDef d) {
        EasyASTIteratorVisitor visitor = EasyASTIteratorVisitor.create((SimpleNode)d);
        Iterator it = visitor.getMethodsIterator();
        while (it.hasNext()) {
            String rep;
            ASTEntry next = (ASTEntry)it.next();
            if (next.node == null || !"__init__".equals(rep = NodeUtils.getRepresentationString((SimpleNode)next.node))) continue;
            return next;
        }
        return null;
    }
}

