/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.refactoring.tdd.AbstractPyCreateAction;
import com.rc.retroweaver.runtime.Autobox;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.templates.PyDocumentTemplateContext;
import org.python.pydev.editor.codecompletion.templates.PyTemplateCompletionProcessor;
import org.python.pydev.editor.correctionassist.heuristics.AssistAssign;
import org.python.pydev.editor.templates.PyContextType;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.adapters.offsetstrategy.BeginOffset;
import org.python.pydev.refactoring.ast.adapters.offsetstrategy.EndOffset;
import org.python.pydev.refactoring.core.base.RefactoringInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPyCreateClassOrMethodOrField
extends AbstractPyCreateAction {
    public abstract String getCreationStr();

    @Override
    public void execute(RefactoringInfo refactoringInfo, int locationStrategy) {
        try {
            String creationStr = this.getCreationStr();
            final String asTitle = StringUtils.getWithFirstUpper((String)creationStr);
            PySelection pySelection = refactoringInfo.getPySelection();
            Tuple currToken = pySelection.getCurrToken();
            String actTok = (String)currToken.o1;
            List parametersAfterCall = null;
            if (actTok.length() == 0) {
                InputDialog dialog = new InputDialog(PyAction.getShell(), new StringBuffer(String.valueOf(asTitle)).append(" name").toString(), new StringBuffer("Please enter the name of the ").append(asTitle).append(" to be created.").toString(), "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "The " + asTitle + " name may not be empty";
                        }
                        if (StringUtils.containsWhitespace((String)newText)) {
                            return "The " + asTitle + " name may not contain whitespaces.";
                        }
                        return null;
                    }
                });
                if (dialog.open() != 0) {
                    return;
                }
                actTok = dialog.getValue();
            } else {
                parametersAfterCall = pySelection.getParametersAfterCall((Integer)currToken.o2 + actTok.length());
            }
            this.execute(refactoringInfo, actTok, parametersAfterCall, locationStrategy);
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }

    void execute(RefactoringInfo refactoringInfo, String actTok, List<String> parametersAfterCall, int locationStrategy) {
        try {
            ICompletionProposal proposal = this.createProposal(refactoringInfo, actTok, locationStrategy, parametersAfterCall);
            if (proposal != null) {
                if (proposal instanceof ICompletionProposalExtension2) {
                    ICompletionProposalExtension2 extension2 = (ICompletionProposalExtension2)proposal;
                    extension2.apply((ITextViewer)this.targetEditor.getPySourceViewer(), '\n', 0, 0);
                } else {
                    proposal.apply(refactoringInfo.getDocument());
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    protected ICompletionProposal createProposal(PySelection pySelection, String source, Tuple<Integer, String> offsetAndIndent) {
        return this.createProposal(pySelection, source, offsetAndIndent, true, null);
    }

    protected ICompletionProposal createProposal(PySelection pySelection, String source, Tuple<Integer, String> offsetAndIndent, boolean requireEmptyLines, Pass replacePassStatement) {
        int offset;
        int len;
        String indent;
        block14: {
            indent = (String)offsetAndIndent.o2;
            if (replacePassStatement == null) {
                len = 0;
                offset = (Integer)offsetAndIndent.o1;
                if (requireEmptyLines) {
                    int checkLine = pySelection.getLineOfOffset(offset);
                    int lineOffset = pySelection.getLineOffset(checkLine);
                    if (lineOffset == offset) {
                        --checkLine;
                    }
                    if (checkLine >= 0) {
                        String line = pySelection.getLine(checkLine);
                        if (line.trim().length() >= 1) {
                            source = new StringBuffer("\n\n").append(source).toString();
                        } else if (checkLine > 1 && (line = pySelection.getLine(checkLine - 1)).trim().length() > 0) {
                            source = new StringBuffer("\n").append(source).toString();
                        }
                    }
                    if (!source.startsWith("\n")) {
                        try {
                            String lineContentsToCursor = pySelection.getLineContentsToCursor(offset);
                            if (lineContentsToCursor.length() > 0) {
                                source = new StringBuffer("\n").append(source).toString();
                                break block14;
                            }
                            source = new StringBuffer(String.valueOf(indent)).append(source).toString();
                        }
                        catch (BadLocationException badLocationException) {
                            source = new StringBuffer("\n").append(source).toString();
                        }
                    }
                }
            } else {
                offset = pySelection.getAbsoluteCursorOffset(replacePassStatement.beginLine - 1, replacePassStatement.beginColumn - 1);
                len = 4;
                if (requireEmptyLines) {
                    source = new StringBuffer("\n\n").append(source).toString();
                }
            }
        }
        if (this.targetEditor != null) {
            String creationStr = this.getCreationStr();
            Region region = new Region(offset, len);
            PyDocumentTemplateContext context = PyTemplateCompletionProcessor.createContext((TemplateContextType)new PyContextType(), (ITextViewer)this.targetEditor.getPySourceViewer(), (IRegion)region, (String)indent);
            Template template = new Template(new StringBuffer("Create ").append(creationStr).toString(), new StringBuffer("Create ").append(creationStr).toString(), "", source, true);
            TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
            return templateProposal;
        }
        source = StringUtils.indentTo((String)source, (String)indent, (boolean)false);
        return new CompletionProposal(source, offset, len, 0);
    }

    protected Tuple<Integer, String> getLocationOffset(int locationStrategy, PySelection pySelection, ModuleAdapter moduleAdapter, IClassDefAdapter targetClass) {
        Assert.isNotNull((Object)targetClass);
        try {
            int offset;
            switch (locationStrategy) {
                case 0: {
                    String currentLine = pySelection.getLine();
                    int firstCharPosition = PySelection.getFirstCharPosition((String)currentLine);
                    PySelection.LineStartingScope scopeStart = pySelection.getPreviousLineThatStartsScope(PySelection.CLASS_AND_FUNC_TOKENS, false, firstCharPosition);
                    if (scopeStart == null) {
                        PydevPlugin.log((String)"Could not get proper scope to create code inside class.");
                        ClassDef astNode = (ClassDef)targetClass.getASTNode();
                        if (astNode.body.length > 0) {
                            offset = NodeUtils.getLineEnd((SimpleNode)astNode.body[astNode.body.length - 1]);
                            break;
                        }
                        offset = NodeUtils.getLineEnd((SimpleNode)astNode);
                        break;
                    }
                    int iLineStartingScope = scopeStart.iLineStartingScope;
                    String line = pySelection.getLine(iLineStartingScope);
                    if ((pySelection.matchesFunctionLine(line) || pySelection.matchesClassLine(line)) && iLineStartingScope > 0) {
                        int i = iLineStartingScope - 1;
                        while (pySelection.getLine(i).trim().startsWith("@")) {
                            iLineStartingScope = i--;
                        }
                    }
                    offset = pySelection.getLineOffset(iLineStartingScope);
                    break;
                }
                case 1: {
                    EndOffset strategy = new EndOffset((IASTNodeAdapter)targetClass, pySelection.getDoc(), moduleAdapter.getAdapterPrefs());
                    offset = strategy.getOffset();
                    break;
                }
                case 2: {
                    BeginOffset strategy = new BeginOffset((IASTNodeAdapter)targetClass, pySelection.getDoc(), moduleAdapter.getAdapterPrefs());
                    offset = strategy.getOffset();
                    break;
                }
                default: {
                    throw new AssertionError((Object)new StringBuffer("Unknown location strategy: ").append(locationStrategy).toString());
                }
            }
            int nodeBodyIndent = targetClass.getNodeBodyIndent();
            return new Tuple((Object)Autobox.valueOf((int)offset), (Object)new FastStringBuffer(nodeBodyIndent).appendN(' ', nodeBodyIndent).toString());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Tuple<Integer, String> getLocationOffset(int locationStrategy, PySelection pySelection, ModuleAdapter moduleAdapter) throws AssertionError {
        switch (locationStrategy) {
            case 0: {
                lastNodeFirstLineBefore = moduleAdapter.getLastNodeFirstLineBefore(pySelection.getCursorLine() + 1);
                line = --lastNodeFirstLineBefore;
                if (line <= 0) ** GOTO lbl20
                try {
                    trimmed = pySelection.getLine(line).trim();
                    if (!trimmed.startsWith("class") && !trimmed.startsWith("def")) ** GOTO lbl20
                    curr = line;
                    while (curr >= 0) {
                        line = curr;
                        if (curr - 1 >= 0 && pySelection.getLine(curr - 1).trim().startsWith("#")) {
                            --curr;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    PydevPlugin.log((Throwable)e);
                }
lbl20:
                // 5 sources

                offset = pySelection.getLineOffset(line);
                break;
            }
            case 1: {
                offset = pySelection.getEndOfDocummentOffset();
                break;
            }
            default: {
                throw new AssertionError((Object)new StringBuffer("Unknown location strategy: ").append(locationStrategy).toString());
            }
        }
        return new Tuple((Object)Autobox.valueOf((int)offset), (Object)"");
    }

    protected FastStringBuffer createParametersList(List<String> parametersAfterCall) {
        FastStringBuffer params = new FastStringBuffer(parametersAfterCall.size() * 10);
        AssistAssign assistAssign = new AssistAssign();
        int i = 0;
        while (i < parametersAfterCall.size()) {
            boolean addTag;
            String part0;
            List split;
            String param = parametersAfterCall.get(i).trim();
            if (params.length() > 0) {
                params.append(", ");
            }
            String tok = null;
            if (param.indexOf(61) != -1 && (split = StringUtils.split((String)param, (char)'=')).size() > 0 && StringUtils.isPythonIdentifier((String)(part0 = ((String)split.get(0)).trim()))) {
                tok = part0;
            }
            if (tok == null) {
                if (StringUtils.isPythonIdentifier((String)param)) {
                    tok = param;
                } else {
                    tok = assistAssign.getTokToAssign(param);
                    if (tok == null || tok.length() == 0) {
                        tok = new StringBuffer("param").append(i).toString();
                    }
                }
            }
            boolean bl = addTag = i != 0 || !tok.equals("cls") && !tok.equals("self");
            if (addTag) {
                params.append("${");
            }
            params.append(tok);
            if (addTag) {
                params.append("}");
            }
            ++i;
        }
        return params;
    }
}

