/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ctrl_1;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.ctrl_1.IAnalysisMarkersParticipant;
import com.python.pydev.analysis.ctrl_1.IgnoreCompletionProposal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreErrorParticipant
implements IAnalysisMarkersParticipant {
    private Image annotationImage;
    private Set<Integer> handled = new HashSet<Integer>();

    public IgnoreErrorParticipant() {
        ImageCache analysisImageCache = PydevPlugin.getImageCache();
        this.annotationImage = analysisImageCache.get("icons/annotation_obj.gif");
    }

    @Override
    public void addProps(MarkerAnnotationAndPosition marker, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, PyEdit edit, List<ICompletionProposal> props) throws BadLocationException, CoreException {
        Integer id = (Integer)marker.markerAnnotation.getMarker().getAttribute("PYDEV_TYPE");
        if (this.handled.contains(id)) {
            return;
        }
        this.handled.add(id);
        String messageToIgnore = analysisPreferences.getRequiredMessageToIgnore(id);
        if (line.indexOf(messageToIgnore) != -1) {
            return;
        }
        String strToAdd = messageToIgnore;
        char lastChar = line.charAt(line.length() - 1);
        if (line.indexOf("#") == -1) {
            strToAdd = new StringBuffer("#").append(strToAdd).toString();
        }
        if (!Character.isWhitespace(lastChar)) {
            strToAdd = new StringBuffer(" ").append(strToAdd).toString();
        }
        IgnoreCompletionProposal proposal = new IgnoreCompletionProposal(strToAdd, ps.getEndLineOffset(), 0, offset, this.annotationImage, messageToIgnore.substring(1), null, null, 10, edit);
        props.add((ICompletionProposal)proposal);
    }
}

