/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.additionalinfo.IInfo;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisPlugin
extends AbstractUIPlugin {
    private static AnalysisPlugin plugin;

    public AnalysisPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static void getDefinitionFromIInfo(List<ItemPointer> pointers, ICodeCompletionASTManager manager, IPythonNature nature, IInfo info, ICompletionCache completionCache) {
        IModule mod = manager.getModule(info.getDeclaringModuleName(), nature, true);
        if (mod != null) {
            String tok = "";
            String path = info.getPath();
            if (path != null && path.length() > 0) {
                tok = new StringBuffer(String.valueOf(path)).append(".").toString();
            }
            tok = new StringBuffer(String.valueOf(tok)).append(info.getName()).toString();
            try {
                IDefinition[] definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)tok, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature);
                if ((definitions == null || definitions.length == 0) && path != null && path.length() > 0) {
                    definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)path, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature);
                }
                PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])((Definition[])definitions));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static AnalysisPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.python.pydev.analysis", (String)path);
    }

    public static Image getImageForAutoImportTypeInfo(IInfo info) {
        ImageCache imageCache = PydevPlugin.getImageCache();
        switch (info.getType()) {
            case 1: {
                return imageCache.getImageDecorated("icons/new/class_obj.gif", "icons/new/imp_dec.gif", 1);
            }
            case 2: {
                return imageCache.getImageDecorated("icons/new/method_obj.gif", "icons/new/imp_dec.gif", 1);
            }
            case 3: {
                return imageCache.getImageDecorated("icons/new/attrpub_obj.gif", "icons/new/imp_dec.gif", 1);
            }
        }
        throw new RuntimeException("Undefined type.");
    }

    public static Image getImageForTypeInfo(IInfo info) {
        ImageCache imageCache = PydevPlugin.getImageCache();
        switch (info.getType()) {
            case 1: {
                return imageCache.get("icons/new/class_obj.gif");
            }
            case 2: {
                return imageCache.get("icons/new/method_obj.gif");
            }
            case 3: {
                return imageCache.get("icons/new/attrpub_obj.gif");
            }
        }
        throw new RuntimeException("Undefined type.");
    }

    public static File getStorageDirForProject(IProject p) {
        IPath location;
        IPath path = location = p.getWorkingLocation(plugin.getBundle().getSymbolicName());
        File file = new File(path.toOSString());
        return file;
    }

    public static String getPluginID() {
        return AnalysisPlugin.getDefault().getBundle().getSymbolicName();
    }
}

