/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.exprType;

public class DictComp
extends exprType {
    public exprType key;
    public exprType value;
    public comprehensionType[] generators;

    public DictComp(exprType key, exprType value, comprehensionType[] generators) {
        this.key = key;
        this.value = value;
        this.generators = generators;
    }

    public DictComp(exprType key, exprType value, comprehensionType[] generators, SimpleNode parent) {
        this(key, value, generators);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DictComp[");
        sb.append("key=");
        sb.append(this.dumpThis(this.key));
        sb.append(", ");
        sb.append("value=");
        sb.append(this.dumpThis(this.value));
        sb.append(", ");
        sb.append("generators=");
        sb.append(this.dumpThis(this.generators));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitDictComp(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.key != null) {
            this.key.accept(visitor);
        }
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.generators != null) {
            int i = 0;
            while (i < this.generators.length) {
                if (this.generators[i] != null) {
                    this.generators[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

