/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;

public class ClassDef
extends stmtType {
    public NameTokType name;
    public exprType[] bases;
    public stmtType[] body;
    public decoratorsType[] decs;
    public keywordType[] keywords;
    public exprType starargs;
    public exprType kwargs;

    public ClassDef(NameTokType name, exprType[] bases, stmtType[] body, decoratorsType[] decs, keywordType[] keywords, exprType starargs, exprType kwargs) {
        this.name = name;
        this.bases = bases;
        this.body = body;
        this.decs = decs;
        this.keywords = keywords;
        this.starargs = starargs;
        this.kwargs = kwargs;
    }

    public ClassDef(NameTokType name, exprType[] bases, stmtType[] body, decoratorsType[] decs, keywordType[] keywords, exprType starargs, exprType kwargs, SimpleNode parent) {
        this(name, bases, body, decs, keywords, starargs, kwargs);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClassDef[");
        sb.append("name=");
        sb.append(this.dumpThis(this.name));
        sb.append(", ");
        sb.append("bases=");
        sb.append(this.dumpThis(this.bases));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("decs=");
        sb.append(this.dumpThis(this.decs));
        sb.append(", ");
        sb.append("keywords=");
        sb.append(this.dumpThis(this.keywords));
        sb.append(", ");
        sb.append("starargs=");
        sb.append(this.dumpThis(this.starargs));
        sb.append(", ");
        sb.append("kwargs=");
        sb.append(this.dumpThis(this.kwargs));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitClassDef(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.bases != null) {
            i = 0;
            while (i < this.bases.length) {
                if (this.bases[i] != null) {
                    this.bases[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.body != null) {
            i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.decs != null) {
            i = 0;
            while (i < this.decs.length) {
                if (this.decs[i] != null) {
                    this.decs[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.keywords != null) {
            i = 0;
            while (i < this.keywords.length) {
                if (this.keywords[i] != null) {
                    this.keywords[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.starargs != null) {
            this.starargs.accept(visitor);
        }
        if (this.kwargs != null) {
            this.kwargs.accept(visitor);
        }
    }
}

