/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.blocks;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.dialogs.PythonModulePickerDialog;

public class MainModuleBlock
extends AbstractLaunchConfigurationTab {
    private Text fMainModuleText;
    private Button fMainModuleBrowseButton;
    private String fProjectName;
    private ModifyListener fProjectModifyListener;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        this.setControl((Control)group);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        group.setText("Main Module");
        this.fMainModuleText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fMainModuleText.setLayoutData((Object)gd);
        this.fMainModuleText.setFont(font);
        this.fMainModuleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                MainModuleBlock.this.updateLaunchConfigurationDialog();
            }
        });
        final Composite lParent = parent;
        this.fMainModuleBrowseButton = this.createPushButton((Composite)group, "Browse...", null);
        this.fMainModuleBrowseButton.setText("Browse");
        this.fMainModuleBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile currentFile = MainModuleBlock.this.getMainModuleFile();
                IResource resource = workspace.getRoot().findMember(MainModuleBlock.this.fProjectName);
                if (resource instanceof IProject) {
                    Object[] results;
                    IProject project = (IProject)resource;
                    PythonModulePickerDialog dialog = new PythonModulePickerDialog(lParent.getShell(), "Main Module", "Choose Python module which starts execution", project);
                    dialog.setInitialSelection((Object)currentFile);
                    int result = dialog.open();
                    if (result == 0 && (results = dialog.getResult()) != null && results.length > 0 && results[0] instanceof IFile) {
                        IFile file = (IFile)results[0];
                        IPath path = file.getFullPath();
                        String containerName = path.makeRelative().toString();
                        MainModuleBlock.this.fMainModuleText.setText("${workspace_loc:" + containerName + "}");
                    }
                }
            }
        });
        this.fProjectModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Widget widget = e.widget;
                if (widget instanceof Text) {
                    Text text = (Text)widget;
                    MainModuleBlock.this.fProjectName = text.getText();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IResource resource = workspace.getRoot().findMember(MainModuleBlock.this.fProjectName);
                    boolean enabled = false;
                    if (resource != null && resource instanceof IProject) {
                        IProject project = (IProject)resource;
                        PythonNature nature = PythonNature.getPythonNature((IProject)project);
                        enabled = nature != null;
                    }
                    MainModuleBlock.this.fMainModuleBrowseButton.setEnabled(enabled);
                }
            }
        };
    }

    public String getName() {
        return "Main module";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String location = "";
        try {
            location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
        }
        catch (CoreException coreException) {}
        this.fMainModuleText.setText(location);
        String projectName = "";
        try {
            projectName = configuration.getAttribute("org.python.pydev.debug.ATTR_PROJECT", "");
        }
        catch (CoreException coreException) {}
        this.fProjectName = projectName;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String value = this.fMainModuleText.getText().trim();
        this.setAttribute(configuration, "org.eclipse.ui.externaltools.ATTR_LOCATION", value);
        configuration.setMappedResources(new IResource[]{this.getMainModuleFile()});
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private IFile getMainModuleFile() {
        String path = this.fMainModuleText.getText();
        IFile file = null;
        if (path.length() > 0) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IFile[] files = root.findFilesForLocation((IPath)new Path(path));
                    if (files.length > 0) {
                        file = files[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                IFile[] files = root.findFilesForLocation((IPath)new Path(path));
                if (files.length > 0) {
                    file = files[0];
                }
            }
        }
        return file;
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy configuration, String name, String value) {
        if (value == null || value.length() == 0) {
            configuration.setAttribute(name, null);
        } else {
            configuration.setAttribute(name, value);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result;
        block9: {
            result = super.isValid(launchConfig);
            if (result) {
                this.setMessage(null);
                this.setErrorMessage(null);
                IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
                String location = this.fMainModuleText.getText();
                try {
                    String identifier = launchConfig.getType().getIdentifier();
                    if (identifier.equals("org.python.pydev.debug.unittestLaunchConfigurationType") || identifier.equals("org.python.pydev.debug.jythonUnittestLaunchConfigurationType") || identifier.equals("org.python.pydev.debug.coverageLaunchConfigurationType")) {
                        String[] stringArray = StringUtils.split((String)location, (char)'|');
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String loc = stringArray[n2];
                            String expandedLocation = stringVariableManager.performStringSubstitution(loc);
                            File file = new File(expandedLocation);
                            if (!file.exists()) {
                                this.setErrorMessage(StringUtils.format((String)"The file \"%s\" does not exist.", (Object[])new Object[]{file}));
                                result = false;
                                break block9;
                            }
                            ++n2;
                        }
                        break block9;
                    }
                    String expandedLocation = stringVariableManager.performStringSubstitution(location);
                    File file = new File(expandedLocation);
                    if (!file.exists()) {
                        this.setErrorMessage(StringUtils.format((String)"The file \"%s\" does not exist.", (Object[])new Object[]{file}));
                        result = false;
                    } else if (!file.isFile()) {
                        this.setErrorMessage(StringUtils.format((String)"The file \"%s\" does not actually map to a file.", (Object[])new Object[]{file}));
                        result = false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage("Unable to resolve location");
                    result = false;
                }
            }
        }
        return result;
    }

    public ModifyListener getProjectModifyListener() {
        return this.fProjectModifyListener;
    }
}

