/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.NotConfiguredInterpreterException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChooseProcessTypeDialog
extends Dialog {
    private Button checkboxForCurrentEditor;
    private Button checkboxPython;
    private Button checkboxJython;
    private PyEdit activeEditor;
    private Collection<String> pythonpath;
    private IInterpreterManager interpreterManager;
    private List<IPythonNature> natures = new ArrayList<IPythonNature>();

    ChooseProcessTypeDialog(Shell shell, PyEdit activeEditor) {
        super(shell);
        this.activeEditor = activeEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.checkboxForCurrentEditor = new Button(area, 16);
        this.checkboxForCurrentEditor.setToolTipText("Creates a console with the PYTHONPATH used by the current editor (and jython/python depending on the project type).");
        this.configureEditorButton();
        this.checkboxPython = new Button(area, 16);
        this.checkboxPython.setToolTipText("Creates a Python console with the PYTHONPATH containing all the python projects in the workspace.");
        this.configureButton(this.checkboxPython, "Python", PydevPlugin.getPythonInterpreterManager());
        this.checkboxJython = new Button(area, 16);
        this.checkboxJython.setToolTipText("Creates a Jython console with the PYTHONPATH containing all the python projects in the workspace.");
        this.configureButton(this.checkboxJython, "Jython", PydevPlugin.getJythonInterpreterManager());
        return area;
    }

    private void configureButton(Button checkBox, String python, IInterpreterManager interpreterManager) {
        String text;
        boolean enabled = false;
        try {
            if (interpreterManager.getDefaultInterpreter() == null) {
                throw new NotConfiguredInterpreterException();
            }
            text = new StringBuffer(String.valueOf(python)).append(" console").toString();
            enabled = true;
        }
        catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
            text = new StringBuffer("Unable to create console for ").append(python).append(" (interpreter not configured)").toString();
        }
        checkBox.setText(text);
        checkBox.setEnabled(enabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureEditorButton() {
        String text;
        boolean enabled = false;
        try {
            if (this.activeEditor != null) {
                IPythonNature nature = this.activeEditor.getPythonNature();
                if (nature != null) {
                    if (nature.getRelatedInterpreterManager().getDefaultInterpreter() == null) throw new NotConfiguredInterpreterException();
                    text = "Console for currently active editor";
                    enabled = true;
                } else {
                    text = "No python nature configured for the current editor";
                }
            } else {
                text = "Unable to create console for current editor (no active editor)";
            }
        }
        catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
            text = "Unable to create console for current editor (interpreter not configured for the editor)";
        }
        this.checkboxForCurrentEditor.setText(text);
        this.checkboxForCurrentEditor.setEnabled(enabled);
    }

    protected void okPressed() {
        IInterpreterManager localInterpreterManager = null;
        if (this.checkboxForCurrentEditor.isEnabled() && this.checkboxForCurrentEditor.getSelection()) {
            IProject project = this.activeEditor.getProject();
            PythonNature nature = PythonNature.getPythonNature((IProject)project);
            this.natures.add((IPythonNature)nature);
            IInterpreterManager relatedInterpreterManager = nature.getRelatedInterpreterManager();
            this.pythonpath = new ArrayList<String>(nature.getPythonPathNature().getCompleteProjectPythonPath(relatedInterpreterManager.getDefaultInterpreter(), relatedInterpreterManager));
            this.interpreterManager = relatedInterpreterManager;
        } else if (this.checkboxPython.isEnabled() && this.checkboxPython.getSelection()) {
            localInterpreterManager = PydevPlugin.getPythonInterpreterManager();
        } else if (this.checkboxJython.isEnabled() && this.checkboxJython.getSelection()) {
            localInterpreterManager = PydevPlugin.getJythonInterpreterManager();
        }
        if (localInterpreterManager != null) {
            this.interpreterManager = localInterpreterManager;
            String defaultInterpreter = localInterpreterManager.getDefaultInterpreter();
            IWorkspace w = ResourcesPlugin.getWorkspace();
            HashSet<String> pythonpath = new HashSet<String>();
            IProject[] iProjectArray = w.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                PythonNature nature = PythonNature.getPythonNature((IProject)p);
                try {
                    if (nature != null && nature.getRelatedInterpreterManager() == localInterpreterManager) {
                        this.natures.add((IPythonNature)nature);
                        pythonpath.addAll(nature.getPythonPathNature().getCompleteProjectPythonPath(defaultInterpreter, localInterpreterManager));
                    }
                }
                catch (Exception e) {
                    PydevPlugin.log((Throwable)e);
                }
                ++n2;
            }
            this.pythonpath = pythonpath;
        }
        super.okPressed();
    }

    public Collection<String> getPythonpath() {
        return this.pythonpath;
    }

    public IInterpreterManager getInterpreterManager() {
        return this.interpreterManager;
    }

    public List<IPythonNature> getNatures() {
        return this.natures;
    }
}

