/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;

public class ImportsSelection {
    public static ICodeCompletionASTManager.ImportInfo getImportsTipperStr(String trimmedLine, boolean returnEvenEmpty) {
        int i;
        String importMsg = "";
        if (!trimmedLine.startsWith("from") && !trimmedLine.startsWith("import")) {
            return new ICodeCompletionASTManager.ImportInfo("", false);
        }
        int fromIndex = trimmedLine.indexOf("from");
        int importIndex = trimmedLine.indexOf("import");
        boolean foundImportOnArray = false;
        if (fromIndex != -1 || importIndex != -1) {
            trimmedLine = trimmedLine.replaceAll("#.*", "");
            String[] strings = trimmedLine.split(" ");
            if (fromIndex != -1 && importIndex == -1 && strings.length > 2) {
                return new ICodeCompletionASTManager.ImportInfo("", foundImportOnArray);
            }
            int i2 = 0;
            while (i2 < strings.length) {
                if (strings[i2].equals("import")) {
                    foundImportOnArray = true;
                }
                if (!strings[i2].equals("from") && !strings[i2].equals("import")) {
                    if (importMsg.length() != 0) {
                        importMsg = String.valueOf(importMsg) + '.';
                    }
                    importMsg = String.valueOf(importMsg) + strings[i2];
                }
                if (fromIndex != -1 && importIndex == -1 && (foundImportOnArray || i2 == strings.length - 1)) {
                    if (importMsg.length() == 0) {
                        return ImportsSelection.doExistingOrEmptyReturn(returnEvenEmpty, importMsg, foundImportOnArray);
                    }
                    if (importMsg.startsWith(".")) {
                        return new ICodeCompletionASTManager.ImportInfo(importMsg, foundImportOnArray);
                    }
                    if (importMsg.indexOf(".") == -1) {
                        return ImportsSelection.doExistingOrEmptyReturn(returnEvenEmpty, importMsg, foundImportOnArray);
                    }
                    return new ICodeCompletionASTManager.ImportInfo(importMsg.substring(0, importMsg.lastIndexOf(".") + 1), foundImportOnArray);
                }
                ++i2;
            }
            if (fromIndex != -1 && importIndex != -1 && strings.length == 3) {
                importMsg = String.valueOf(importMsg) + '.';
            }
        } else {
            return new ICodeCompletionASTManager.ImportInfo("", foundImportOnArray);
        }
        if (importMsg.indexOf(".") == -1) {
            return ImportsSelection.doExistingOrEmptyReturn(returnEvenEmpty, importMsg, foundImportOnArray);
        }
        if (fromIndex == -1 && importMsg.indexOf(44) != -1) {
            int j;
            if ((importMsg = importMsg.substring(importMsg.lastIndexOf(44) + 1, importMsg.length())).startsWith(".")) {
                importMsg = importMsg.substring(1);
            }
            if ((j = importMsg.lastIndexOf(46)) != -1) {
                importMsg = importMsg.substring(0, j);
                return new ICodeCompletionASTManager.ImportInfo(importMsg, foundImportOnArray);
            }
            return ImportsSelection.doExistingOrEmptyReturn(returnEvenEmpty, importMsg, foundImportOnArray);
        }
        boolean removed = false;
        while ((i = importMsg.indexOf(44)) != -1) {
            int j;
            if (importMsg.charAt(i - 1) == '.') {
                j = importMsg.lastIndexOf(46);
                importMsg = importMsg.substring(0, j);
            }
            j = importMsg.lastIndexOf(46);
            importMsg = importMsg.substring(0, j);
            removed = true;
        }
        if (!removed && importMsg.length() > 0 && importMsg.indexOf(46) != -1) {
            importMsg = importMsg.substring(0, importMsg.lastIndexOf(46));
        }
        return new ICodeCompletionASTManager.ImportInfo(importMsg, foundImportOnArray);
    }

    public static ICodeCompletionASTManager.ImportInfo getImportsTipperStr(IDocument doc, int documentOffset) {
        PySelection.DocIterator iterator = new PySelection.DocIterator(false, new PySelection(doc, documentOffset));
        StringBuffer buffer = new StringBuffer();
        boolean expectContinue = false;
        boolean allEndingWithSlash = true;
        boolean found = false;
        while (iterator.hasNext()) {
            String line = ParsingUtils.removeComments(iterator.next());
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("from") || trimmedLine.startsWith("import")) {
                if (expectContinue) {
                    boolean correct = false;
                    if (trimmedLine.indexOf(40) != -1) {
                        correct = true;
                    }
                    if (trimmedLine.endsWith("\\") && allEndingWithSlash) {
                        correct = true;
                    }
                    if (!correct) break;
                }
                found = true;
                buffer.insert(0, trimmedLine);
                break;
            }
            if (expectContinue) {
                if (trimmedLine.indexOf(41) != -1) break;
                if (allEndingWithSlash && trimmedLine.length() > 0) {
                    char c = trimmedLine.charAt(trimmedLine.length() - 1);
                    if (c != '\\' && c != ',' && c != '(') break;
                    if (c != '\\') {
                        allEndingWithSlash = false;
                    }
                } else if (trimmedLine.length() == 0) break;
            }
            expectContinue = true;
            buffer.insert(0, line);
        }
        if (!found) {
            return new ICodeCompletionASTManager.ImportInfo("", false);
        }
        return ImportsSelection.getImportsTipperStr(buffer.toString(), true);
    }

    private static ICodeCompletionASTManager.ImportInfo doExistingOrEmptyReturn(boolean returnEvenEmpty, String importMsg, boolean foundImportOnArray) {
        if (returnEvenEmpty || importMsg.trim().length() > 0) {
            return new ICodeCompletionASTManager.ImportInfo(" ", foundImportOnArray);
        }
        return new ICodeCompletionASTManager.ImportInfo("", foundImportOnArray);
    }
}

