/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.NotConfiguredInterpreterException;
import org.python.pydev.ui.interpreters.IInterpreterObserver;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterManager
implements IInterpreterManager {
    private Map<String, InterpreterInfo> exeToInfo = new HashMap<String, InterpreterInfo>();
    private Preferences prefs;
    private String[] interpretersFromPersistedString;
    protected transient IToken[] builtinCompletions;
    protected transient IModule builtinMod;
    private Object lock = new Object();
    private String persistedCache;
    private String[] persistedCacheRet;
    String persistedString;

    protected abstract String getPreferenceName();

    protected abstract String getNotConfiguredInterpreterMsg();

    public abstract Tuple<InterpreterInfo, String> createInterpreterInfo(String var1, IProgressMonitor var2) throws CoreException, JDTNotAvailableException;

    public abstract boolean canGetInfoOnNature(IPythonNature var1);

    public void setBuiltinCompletions(IToken[] comps) {
        this.builtinCompletions = comps;
    }

    public IToken[] getBuiltinCompletions() {
        return this.builtinCompletions;
    }

    public IModule getBuiltinMod() {
        return this.builtinMod;
    }

    public void setBuiltinMod(IModule mod) {
        this.builtinMod = mod;
    }

    public AbstractInterpreterManager(Preferences prefs) {
        this.prefs = prefs;
        prefs.setDefault(this.getPreferenceName(), "");
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
        for (IInterpreterObserver observer : participants) {
            observer.notifyInterpreterManagerRecreated(this);
        }
        prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                AbstractInterpreterManager.this.clearCaches();
            }
        });
    }

    public void clearCaches() {
        this.builtinMod = null;
        this.builtinCompletions = null;
        this.interpretersFromPersistedString = null;
    }

    public String getDefaultInterpreter() throws NotConfiguredInterpreterException {
        String[] interpreters = this.getInterpreters();
        if (interpreters.length > 0) {
            String interpreter = interpreters[0];
            if (interpreter == null) {
                throw new NotConfiguredInterpreterException(new StringBuffer("The configured interpreter is null, some error happened getting it.\n").append(this.getNotConfiguredInterpreterMsg()).toString());
            }
            return interpreter;
        }
        throw new NotConfiguredInterpreterException(new StringBuffer(String.valueOf(this.getClass().getName())).append(":").append(this.getNotConfiguredInterpreterMsg()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllBut(List<String> allButTheseInterpreters) {
        Map<String, InterpreterInfo> map = this.exeToInfo;
        synchronized (map) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String interpreter : this.exeToInfo.keySet()) {
                if (allButTheseInterpreters.contains(interpreter)) continue;
                toRemove.add(interpreter);
            }
            for (String object : toRemove) {
                this.exeToInfo.remove(object);
            }
        }
    }

    public String[] getInterpreters() {
        if (this.interpretersFromPersistedString == null) {
            this.interpretersFromPersistedString = this.getInterpretersFromPersistedString(this.getPersistedString());
        }
        return this.interpretersFromPersistedString;
    }

    public boolean hasInfoOnInterpreter(String interpreter) {
        String[] interpreters;
        if (interpreter == null) {
            InterpreterInfo info = this.exeToInfo.get(this.getDefaultInterpreter());
            return info != null;
        }
        interpreter = interpreter.toLowerCase();
        String[] stringArray = interpreters = this.getInterpreters();
        int n = interpreters.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().equals(interpreter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public InterpreterInfo getDefaultInterpreterInfo(IProgressMonitor monitor) {
        String interpreter = this.getDefaultInterpreter();
        return this.getInterpreterInfo(interpreter, monitor);
    }

    protected static InterpreterInfo createInfoFromOutput(IProgressMonitor monitor, Tuple<String, String> outTup) {
        if (outTup.o1 == null || ((String)outTup.o1).trim().length() == 0) {
            throw new RuntimeException(new StringBuffer("No output was in the standard output when trying to create the interpreter info.\nThe error output contains:>>").append((String)outTup.o2).append("<<").toString());
        }
        InterpreterInfo info = InterpreterInfo.fromString((String)outTup.o1);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InterpreterInfo getInterpreterInfo(String executable, IProgressMonitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            InterpreterInfo info = this.exeToInfo.get(executable);
            if (info != null) return info;
            monitor.worked(5);
            Tuple<InterpreterInfo, String> tup = null;
            try {
                tup = this.createInterpreterInfo(executable, monitor);
                if (tup == null) {
                    return null;
                }
                info = (InterpreterInfo)tup.o1;
            }
            catch (RuntimeException e) {
                PydevPlugin.log(e);
                throw e;
            }
            catch (Exception e) {
                PydevPlugin.log(e);
                throw new RuntimeException(e);
            }
            if (info.executableOrJar != null && info.executableOrJar.trim().length() > 0) {
                this.exeToInfo.put(info.executableOrJar, info);
                return info;
            }
            final String title = new StringBuffer("Invalid interpreter:").append(executable).toString();
            String reasonCreation = new StringBuffer("The interpreter (or jar): '").append(executable).append("' is not valid - info.executable found: ").append(info.executableOrJar).append("\n").toString();
            if (tup != null) {
                reasonCreation = new StringBuffer(String.valueOf(reasonCreation)).append("The standard output gotten from the executed shell was: >>").append((String)tup.o2).append("<<").toString();
            }
            final String reason = reasonCreation;
            try {
                Display disp = Display.getDefault();
                disp.asyncExec(new Runnable(){

                    public void run() {
                        ErrorDialog.openError(null, (String)title, (String)"Unable to get information on interpreter!", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, reason, null));
                    }
                });
                throw new RuntimeException(reason);
            }
            catch (Throwable throwable) {}
            throw new RuntimeException(reason);
        }
    }

    public String addInterpreter(String executable, IProgressMonitor monitor) {
        this.exeToInfo.remove(executable);
        InterpreterInfo info = this.getInterpreterInfo(executable, monitor);
        if (info == null) {
            return null;
        }
        return info.executableOrJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInterpretersFromPersistedString(String persisted) {
        Object object = this.lock;
        synchronized (object) {
            if (persisted == null || persisted.trim().length() == 0) {
                return new String[0];
            }
            if (this.persistedCache == null || !this.persistedCache.equals(persisted)) {
                ArrayList<String> ret = new ArrayList<String>();
                try {
                    String[] strings;
                    ArrayList<InterpreterInfo> list = new ArrayList<InterpreterInfo>();
                    String[] stringArray = strings = persisted.split("&&&&&");
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        try {
                            list.add(InterpreterInfo.fromString(string));
                        }
                        catch (Exception e) {
                            String errMsg = "Interpreter storage changed.\r\nPlease restore it (window > preferences > Pydev > Interpreter)";
                            PydevPlugin.log(errMsg, e);
                            return new String[0];
                        }
                        ++n2;
                    }
                    for (final InterpreterInfo info : list) {
                        if (info == null || info.executableOrJar == null) continue;
                        this.exeToInfo.put(info.executableOrJar, info);
                        ret.add(info.executableOrJar);
                    }
                    for (final InterpreterInfo info : list) {
                        try {
                            ISystemModulesManager systemModulesManager = (ISystemModulesManager)PydevPlugin.readFromWorkspaceMetadata(info.getExeAsFileSystemValidPath());
                            info.setModulesManager(systemModulesManager);
                        }
                        catch (Exception exception) {
                            final Display def = Display.getDefault();
                            def.syncExec(new Runnable(){

                                public void run() {
                                    Shell shell = def.getActiveShell();
                                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                                    dialog.setBlockOnOpen(false);
                                    try {
                                        dialog.run(false, false, new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                monitor.beginTask("Updating the interpreter info (internal storage format changed).", 100);
                                                info.restorePythonpath(monitor);
                                                PydevPlugin.writeToWorkspaceMetadata(info.getModulesManager(), info.getExeAsFileSystemValidPath());
                                                monitor.done();
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            });
                            System.out.println(new StringBuffer("Finished restoring information for: ").append(info.executableOrJar).toString());
                        }
                    }
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                    return new String[0];
                }
                this.persistedCache = persisted;
                this.persistedCacheRet = ret.toArray(new String[0]);
            }
        }
        return this.persistedCacheRet;
    }

    public String getStringToPersist(String[] executables) {
        FastStringBuffer buf = new FastStringBuffer();
        String[] stringArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            String exe = stringArray[n2];
            InterpreterInfo info = this.exeToInfo.get(exe);
            if (info != null) {
                buf.append(info.toString());
                buf.append("&&&&&");
            }
            ++n2;
        }
        return buf.toString();
    }

    public String getPersistedString() {
        if (this.persistedString == null) {
            this.persistedString = this.prefs.getString(this.getPreferenceName());
        }
        return this.persistedString;
    }

    public void setPersistedString(String s) {
        this.persistedString = s;
        this.prefs.setValue(this.getPreferenceName(), s);
    }

    public void saveInterpretersInfoModulesManager() {
        for (InterpreterInfo info : this.exeToInfo.values()) {
            PydevPlugin.writeToWorkspaceMetadata(info.getModulesManager(), info.getExeAsFileSystemValidPath());
        }
    }

    public boolean hasInfoOnDefaultInterpreter(IPythonNature nature) {
        if (!this.canGetInfoOnNature(nature)) {
            throw new RuntimeException("Cannot get info on the requested nature");
        }
        try {
            InterpreterInfo info = this.exeToInfo.get(this.getDefaultInterpreter());
            return info != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePythopathFor(IProgressMonitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            for (String interpreter : this.exeToInfo.keySet()) {
                InterpreterInfo info = this.getInterpreterInfo(interpreter, monitor);
                info.restorePythonpath(monitor);
                List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
                for (IInterpreterObserver observer : participants) {
                    try {
                        observer.notifyDefaultPythonpathRestored(this, interpreter, monitor);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                }
            }
        }
    }

    public boolean isConfigured() {
        String defaultInterpreter;
        block3: {
            try {
                defaultInterpreter = this.getDefaultInterpreter();
                if (defaultInterpreter != null) break block3;
                return false;
            }
            catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
                return false;
            }
        }
        return defaultInterpreter.length() != 0;
    }

    public int getRelatedId() {
        if (this.isPython()) {
            return 0;
        }
        if (this.isJython()) {
            return 1;
        }
        throw new RuntimeException("Expected Python or Jython");
    }

    public /* synthetic */ IInterpreterInfo getDefaultInterpreterInfo(IProgressMonitor iProgressMonitor) {
        return this.getDefaultInterpreterInfo(iProgressMonitor);
    }

    public /* synthetic */ IInterpreterInfo getInterpreterInfo(String string, IProgressMonitor iProgressMonitor) {
        return this.getInterpreterInfo(string, iProgressMonitor);
    }
}

