/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.project;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.ui.PyProjectPythonDetails;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;

public class CopiedWizardNewProjectNameAndLocationPage
extends WizardPage
implements SelectionListener,
IWizardNewProjectNameAndLocationPage {
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private PyProjectPythonDetails.RadioController details;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            CopiedWizardNewProjectNameAndLocationPage.this.setLocationForSelection();
            CopiedWizardNewProjectNameAndLocationPage.this.setPageComplete(CopiedWizardNewProjectNameAndLocationPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            CopiedWizardNewProjectNameAndLocationPage.this.setPageComplete(CopiedWizardNewProjectNameAndLocationPage.this.validatePage());
        }
    };
    private Button checkSrcFolder;
    private boolean checkSrcFolderSelected = true;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public String getProjectType() {
        return this.details.getSelected();
    }

    public CopiedWizardNewProjectNameAndLocationPage(String pageName) {
        super(pageName);
        this.setTitle("Pydev Project");
        this.setDescription("Create a new Pydev Project.");
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = "";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.createProjectDetails(composite);
        this.checkSrcFolder = new Button(composite, 32);
        this.checkSrcFolder.setText("Cr&eate default 'src' folder and add it to the pythonpath?");
        this.checkSrcFolder.setSelection(true);
        this.checkSrcFolder.addSelectionListener((SelectionListener)this);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createProjectDetails(Composite parent) {
        Font font = parent.getFont();
        Composite projectDetails = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        projectDetails.setLayout((Layout)layout);
        projectDetails.setLayoutData((Object)new GridData(768));
        projectDetails.setFont(font);
        Label projectTypeLabel = new Label(projectDetails, 0);
        projectTypeLabel.setFont(font);
        projectTypeLabel.setText("Project type");
        this.details = new PyProjectPythonDetails.RadioController();
        Control createdOn = this.details.doCreateContents(projectDetails);
        this.details.setDefaultSelection();
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        createdOn.setLayoutData((Object)data);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setFont(font);
        projectContentsLabel.setText("Project contents:");
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        projectContentsLabel.setLayoutData((Object)labelData);
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText("Use &default");
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopiedWizardNewProjectNameAndLocationPage.this.useDefaults = useDefaultsButton.getSelection();
                CopiedWizardNewProjectNameAndLocationPage.this.browseButton.setEnabled(!CopiedWizardNewProjectNameAndLocationPage.this.useDefaults);
                CopiedWizardNewProjectNameAndLocationPage.this.locationPathField.setEnabled(!CopiedWizardNewProjectNameAndLocationPage.this.useDefaults);
                CopiedWizardNewProjectNameAndLocationPage.this.locationLabel.setEnabled(!CopiedWizardNewProjectNameAndLocationPage.this.useDefaults);
                if (CopiedWizardNewProjectNameAndLocationPage.this.useDefaults) {
                    CopiedWizardNewProjectNameAndLocationPage.this.customLocationFieldValue = CopiedWizardNewProjectNameAndLocationPage.this.locationPathField.getText();
                    CopiedWizardNewProjectNameAndLocationPage.this.setLocationForSelection();
                } else {
                    CopiedWizardNewProjectNameAndLocationPage.this.locationPathField.setText(CopiedWizardNewProjectNameAndLocationPage.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(font);
        projectLabel.setText("&Project name:");
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(font);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setFont(font);
        this.locationLabel.setText("Director&y");
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText("B&rowse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopiedWizardNewProjectNameAndLocationPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage("Select the project contents directory.");
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    private boolean isExistingProjectLocation() {
        IPath path = this.getLocationPath();
        path = path.append(".project");
        return path.toFile().exists();
    }

    void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProjectNameFieldValue());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    private boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Project name is empty");
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Project location is empty");
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage("Project location is not valid");
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage("Project already exists");
            return false;
        }
        if (this.isExistingProjectLocation()) {
            this.setErrorMessage("Project location already exists");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean shouldCreatSourceFolder() {
        return this.checkSrcFolderSelected;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.checkSrcFolder) {
            this.checkSrcFolderSelected = this.checkSrcFolder.getSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

