/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import com.rc.retroweaver.runtime.ClassLiteral;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.NotConfiguredInterpreterException;

public class PyProjectPythonDetails
extends PropertyPage {
    public IAdaptable element;
    public RadioController radioController = new RadioController();

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IProject getProject() {
        return (IProject)this.getElement().getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IProject"));
    }

    public Control createContents(Composite p) {
        Control contents = this.radioController.doCreateContents(p);
        this.setSelected();
        return contents;
    }

    private void setSelected() {
        PythonNature pythonNature = PythonNature.getPythonNature(this.getProject());
        try {
            String version = pythonNature.getVersion();
            if (IPythonNature.Versions.ALL_PYTHON_VERSIONS.contains(version)) {
                this.radioController.radioPy.setSelection(true);
            } else if (IPythonNature.Versions.ALL_JYTHON_VERSIONS.contains(version)) {
                this.radioController.radioJy.setSelection(true);
            }
            String v = StringUtils.split((String)version, (char)' ')[1];
            this.radioController.comboGrammarVersion.setText(v);
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
    }

    protected void performApply() {
        this.doIt();
    }

    public boolean performOk() {
        return this.doIt();
    }

    private boolean doIt() {
        IProject project = this.getProject();
        if (project != null) {
            String newVersion = this.radioController.getSelected();
            PythonNature pythonNature = PythonNature.getPythonNature(project);
            final IInterpreterManager interpreterManager = IPythonNature.Versions.ALL_JYTHON_VERSIONS.contains(newVersion) ? PydevPlugin.getJythonInterpreterManager() : PydevPlugin.getPythonInterpreterManager();
            try {
                interpreterManager.getDefaultInterpreter();
            }
            catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
                final Display display = Display.getDefault();
                display.syncExec(new Runnable(){

                    public void run() {
                        String msg = "You're currently trying to change your project to a %s project, but there is currently no interpreter configured for it, so, please, go to the menu: window > preferences > Pydev > Interpreter %s and configure it before changing your project type.";
                        String managerRelatedName = interpreterManager.getManagerRelatedName();
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"Invalid Interpreter", (String)StringUtils.format((String)msg, (Object[])new Object[]{managerRelatedName, managerRelatedName}));
                    }
                });
                return false;
            }
            try {
                pythonNature.setVersion(newVersion);
            }
            catch (CoreException e) {
                PydevPlugin.log(e);
            }
        }
        return true;
    }

    public static class RadioController {
        public Button radioPy;
        public Button radioJy;
        public Combo comboGrammarVersion;
        public Label versionLabel;

        public Control doCreateContents(Composite p) {
            Composite topComp = new Composite(p, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 1;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            topComp.setLayout((Layout)innerLayout);
            GridData gd = new GridData(1808);
            topComp.setLayoutData((Object)gd);
            Group group = new Group(topComp, 0);
            group.setText("Choose the project type");
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 8;
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            this.radioPy = new Button((Composite)group, 16400);
            this.radioPy.setText("Python");
            this.radioJy = new Button((Composite)group, 16400);
            this.radioJy.setText("Jython");
            this.versionLabel = new Label(topComp, 0);
            this.versionLabel.setText("Grammar Version");
            gd = new GridData(768);
            this.versionLabel.setLayoutData((Object)gd);
            this.comboGrammarVersion = new Combo(topComp, 8);
            this.comboGrammarVersion.add("2.1");
            this.comboGrammarVersion.add("2.2");
            this.comboGrammarVersion.add("2.3");
            this.comboGrammarVersion.add("2.4");
            this.comboGrammarVersion.add("2.5");
            this.comboGrammarVersion.add("2.6");
            this.comboGrammarVersion.add("3.0");
            gd = new GridData(768);
            this.comboGrammarVersion.setLayoutData((Object)gd);
            return topComp;
        }

        public String getSelected() {
            if (this.radioPy.getSelection()) {
                return "python " + this.comboGrammarVersion.getText();
            }
            if (this.radioJy.getSelection()) {
                return "jython " + this.comboGrammarVersion.getText();
            }
            throw new RuntimeException("Some radio must be selected");
        }

        public void setDefaultSelection() {
            this.radioPy.setSelection(true);
            this.comboGrammarVersion.setText("2.6");
        }
    }
}

