/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ASTManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.AbstractPythonNature;
import org.python.pydev.plugin.nature.IPythonNatureStore;
import org.python.pydev.plugin.nature.PythonNatureListenersManager;
import org.python.pydev.plugin.nature.PythonNatureStore;
import org.python.pydev.plugin.nature.PythonPathNature;
import org.python.pydev.ui.interpreters.IInterpreterObserver;
import org.python.pydev.utils.JobProgressComunicator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonNature
extends AbstractPythonNature
implements IPythonNature {
    private static List<WeakReference<PythonNature>> createdNatures = new ArrayList<WeakReference<PythonNature>>();
    public static final String PYTHON_NATURE_ID = "org.python.pydev.pythonNature";
    public static final String PYTHON_NATURE_NAME = "pythonNature";
    public static final String BUILDER_ID = "org.python.pydev.PyDevBuilder";
    private IProject project;
    private ICodeCompletionASTManager astManager;
    private boolean initializationStarted;
    private boolean initializationFinished;
    private IPythonPathNature pythonPathNature = new PythonPathNature();
    private IPythonNatureStore pythonNatureStore = new PythonNatureStore();
    private static QualifiedName pythonProjectVersion = null;
    private static Map<IProject, Job> jobs = new HashMap<IProject, Job>();
    private RebuildPythonNatureModules rebuildJob = new RebuildPythonNatureModules();
    private String versionPropertyCache = null;
    Boolean isJython = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PythonNature> getInitializedPythonNatures() {
        ArrayList<PythonNature> ret = new ArrayList<PythonNature>();
        List<WeakReference<PythonNature>> list = createdNatures;
        synchronized (list) {
            Iterator<WeakReference<PythonNature>> it = createdNatures.iterator();
            while (it.hasNext()) {
                PythonNature pythonNature = (PythonNature)it.next().get();
                if (pythonNature == null) {
                    it.remove();
                    continue;
                }
                if (pythonNature.getProject() == null) continue;
                ret.add(pythonNature);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonNature() {
        List<WeakReference<PythonNature>> list = createdNatures;
        synchronized (list) {
            createdNatures.add(new WeakReference<PythonNature>(this));
        }
    }

    static QualifiedName getPythonProjectVersionQualifiedName() {
        if (pythonProjectVersion == null) {
            pythonProjectVersion = new QualifiedName(PydevPlugin.getPluginID(), "PYTHON_PROJECT_VERSION");
        }
        return pythonProjectVersion;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProject(final IProject project) {
        this.getStore().setProject(project);
        this.project = project;
        this.pythonPathNature.setProject(project, (IPythonNature)this);
        if (project != null && !this.initializationStarted && !this.initializationFinished) {
            Map<IProject, Job> map = jobs;
            synchronized (map) {
                Job job = jobs.get(project);
                if (job != null) {
                    job.cancel();
                }
                job = new Job("PyDev: Restoring projects python nature"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            PythonNature.this.init(null, null, monitor);
                            Map map = jobs;
                            synchronized (map) {
                                if (jobs.get(project) == this) {
                                    jobs.remove(project);
                                }
                            }
                        }
                        catch (Throwable t) {
                            PydevPlugin.log(t);
                        }
                        return Status.OK_STATUS;
                    }
                };
                jobs.put(project, job);
                job.schedule(250L);
            }
        }
    }

    public static synchronized IPythonNature addNature(IEditorInput element) {
        IFile file;
        if (element instanceof FileEditorInput && (file = (IFile)((FileEditorInput)element).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"))) != null) {
            try {
                return PythonNature.addNature(file.getProject(), null, null, null);
            }
            catch (CoreException e) {
                PydevPlugin.log(e);
            }
        }
        return null;
    }

    public static synchronized void removeNature(IProject project, IProgressMonitor monitor) throws CoreException {
        PythonNature nature;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((nature = PythonNature.getPythonNature(project)) == null) {
            return;
        }
        try {
            nature.pythonNatureStore.setProject(null);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        try {
            nature.pythonPathNature.setProject(null, null);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        try {
            PythonNatureListenersManager.notifyPythonPathRebuilt(project, new ArrayList<String>());
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        try {
            IResource member = project.findMember(".pydevproject");
            member.delete(true, null);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        IProjectDescription description = project.getDescription();
        ArrayList natures = new ArrayList(Arrays.asList(description.getNatureIds()));
        natures.remove(PYTHON_NATURE_ID);
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        project.setDescription(description, monitor);
    }

    public static synchronized IPythonNature addNature(IProject project, IProgressMonitor monitor, String version, String projectPythonpath) throws CoreException {
        PythonNature n;
        ICommand[] commands;
        if (project == null || !project.isOpen()) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProjectDescription desc = project.getDescription();
        if (!project.hasNature(PYTHON_NATURE_ID)) {
            String[] natures = desc.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = PYTHON_NATURE_ID;
            desc.setNatureIds(newNatures);
            project.setDescription(desc, monitor);
        }
        if (!PythonNature.hasBuilder(commands = desc.getBuildSpec()) && PyDevBuilderPrefPage.usePydevBuilders()) {
            ICommand command = desc.newCommand();
            command.setBuilderName(BUILDER_ID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, monitor);
        }
        if ((n = PythonNature.getPythonNature(project)) instanceof PythonNature) {
            PythonNature nature = n;
            nature.init(version, projectPythonpath, monitor);
            return nature;
        }
        return null;
    }

    private static boolean hasBuilder(ICommand[] commands) {
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String version, String projectPythonpath, IProgressMonitor monitor) {
        block25: {
            block24: {
                if (version != null || projectPythonpath != null) {
                    this.getStore().startInit();
                    try {
                        try {
                            if (projectPythonpath != null) {
                                this.getPythonPathNature().setProjectSourcePath(projectPythonpath);
                            }
                            if (version != null) {
                                this.setVersion(version);
                            }
                        }
                        catch (CoreException e) {
                            PydevPlugin.log(e);
                            this.getStore().endInit();
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        this.getStore().endInit();
                        throw throwable;
                    }
                    this.getStore().endInit();
                } else if (this.astManager != null) {
                    return;
                }
            }
            if (this.initializationStarted || monitor.isCanceled()) {
                return;
            }
            this.initializationStarted = true;
            try {
                this.astManager = ASTManager.loadFromFile(this.getAstOutputFile());
                if (this.astManager == null) break block25;
                ICodeCompletionASTManager e = this.astManager;
                synchronized (e) {
                    this.astManager.setProject(this.getProject(), (IPythonNature)this, true);
                    if (this.astManager.getModulesManager().getOnlyDirectModules().length < 5) {
                        this.astManager = null;
                    }
                    if (this.astManager != null) {
                        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
                        for (IInterpreterObserver observer : participants) {
                            try {
                                observer.notifyNatureRecreated(this, monitor);
                            }
                            catch (Exception e2) {
                                PydevPlugin.log(e2);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
                this.astManager = null;
            }
        }
        if (this.astManager == null) {
            try {
                this.rebuildPath(null, monitor);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
        this.initializationFinished = true;
    }

    public static File getCompletionsCacheDir(IProject p) {
        IPath location;
        IPath path = location = p.getWorkingLocation(PydevPlugin.getPluginID());
        File file = new File(path.toOSString());
        return file;
    }

    public File getCompletionsCacheDir() {
        return PythonNature.getCompletionsCacheDir(this.getProject());
    }

    private File getAstOutputFile() {
        return new File(this.getCompletionsCacheDir(), "asthelper.completions");
    }

    public void rebuildPath() {
        this.rebuildPath(null, (IProgressMonitor)new NullProgressMonitor());
    }

    public void rebuildPath(String defaultSelectedInterpreter, IProgressMonitor monitor) {
        try {
            this.clearCaches();
            String paths = this.pythonPathNature.getOnlyProjectPythonPathStr();
            this.rebuildPath(defaultSelectedInterpreter, paths);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void rebuildPath(String defaultSelectedInterpreter, String paths) {
        this.rebuildJob.cancel();
        this.rebuildJob.setParams(paths, defaultSelectedInterpreter);
        this.rebuildJob.schedule(20L);
    }

    public ICodeCompletionASTManager getAstManager() {
        if (this.astManager == null) {
            int i = 0;
            while (i < 10 && this.astManager == null && !this.initializationFinished) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.initializationFinished = true;
        }
        return this.astManager;
    }

    public void setAstManager(ICodeCompletionASTManager astManager) {
        this.astManager = astManager;
    }

    public IPythonPathNature getPythonPathNature() {
        return this.pythonPathNature;
    }

    public static IPythonPathNature getPythonPathNature(IProject project) {
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        if (pythonNature != null) {
            return pythonNature.pythonPathNature;
        }
        return null;
    }

    public static List<IPythonNature> getAllPythonNatures() {
        IProject[] projects;
        ArrayList<IPythonNature> natures = new ArrayList<IPythonNature>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                natures.add(nature);
            }
            ++n2;
        }
        return natures;
    }

    public static PythonNature getPythonNature(IResource resource) {
        if (resource == null) {
            return null;
        }
        return PythonNature.getPythonNature(resource.getProject());
    }

    public static PythonNature getPythonNature(IProject project) {
        if (project != null && project.isOpen()) {
            try {
                IProjectNature n = project.getNature(PYTHON_NATURE_ID);
                if (n instanceof PythonNature) {
                    return (PythonNature)n;
                }
            }
            catch (CoreException e) {
                PydevPlugin.logInfo((Exception)((Object)e));
            }
        }
        return null;
    }

    public String getVersion() throws CoreException {
        if (this.project != null && this.versionPropertyCache == null) {
            String storeVersion = this.getStore().getPropertyFromXml(PythonNature.getPythonProjectVersionQualifiedName());
            if (storeVersion == null) {
                this.setVersion(this.getDefaultVersion());
            } else {
                this.versionPropertyCache = storeVersion;
            }
        }
        return this.versionPropertyCache;
    }

    public void setVersion(String version) throws CoreException {
        this.clearCaches();
        if (this.project != null) {
            this.versionPropertyCache = version;
            this.getStore().setPropertyToXml(PythonNature.getPythonProjectVersionQualifiedName(), version, true);
        }
    }

    public String getDefaultVersion() {
        return "python 2.5";
    }

    public boolean isJython() throws CoreException {
        if (this.isJython == null) {
            this.isJython = Autobox.valueOf((boolean)IPythonNature.Versions.ALL_JYTHON_VERSIONS.contains(this.getVersion()));
        }
        return this.isJython;
    }

    public boolean isPython() throws CoreException {
        return !this.isJython();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAstManager() {
        if (this.astManager == null) {
            REF.writeToFile(null, (File)this.getAstOutputFile());
        } else {
            ICodeCompletionASTManager iCodeCompletionASTManager = this.astManager;
            synchronized (iCodeCompletionASTManager) {
                REF.writeToFile((Object)this.astManager, (File)this.getAstOutputFile());
            }
        }
    }

    public int getRelatedId() throws CoreException {
        return PythonNature.getRelatedId(this);
    }

    public static int getRelatedId(IPythonNature nature) throws CoreException {
        if (nature.isPython()) {
            return 0;
        }
        if (nature.isJython()) {
            return 1;
        }
        throw new RuntimeException("Unable to get the id to which this nature is related");
    }

    public String resolveModule(String fileAbsolutePath) {
        String moduleName = null;
        if (this.astManager != null) {
            moduleName = this.astManager.getModulesManager().resolveModule(fileAbsolutePath);
        }
        return moduleName;
    }

    public static String[] getStrAsStrItems(String str) {
        return str.split("\\|");
    }

    public IInterpreterManager getRelatedInterpreterManager() {
        try {
            if (this.isPython()) {
                return PydevPlugin.getPythonInterpreterManager();
            }
            if (this.isJython()) {
                return PydevPlugin.getJythonInterpreterManager();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Unable to find the related interpreter manager.");
    }

    public void clearCaches() {
        this.isJython = null;
        this.versionPropertyCache = null;
    }

    public void setBuiltinCompletions(IToken[] comps) {
        this.getRelatedInterpreterManager().setBuiltinCompletions(comps);
    }

    public IToken[] getBuiltinCompletions() {
        return this.getRelatedInterpreterManager().getBuiltinCompletions();
    }

    public IModule getBuiltinMod() {
        return this.getRelatedInterpreterManager().getBuiltinMod();
    }

    public void setBuiltinMod(IModule mod) {
        this.getRelatedInterpreterManager().setBuiltinMod(mod);
    }

    public static List<IPythonNature> getPythonNaturesRelatedTo(int relatedTo) {
        IProject[] projects;
        ArrayList<IPythonNature> ret = new ArrayList<IPythonNature>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PythonNature nature = PythonNature.getPythonNature(project);
            try {
                if (nature != null && nature.getRelatedId() == relatedTo) {
                    ret.add(nature);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return ret;
    }

    public int getGrammarVersion() {
        try {
            String version = this.getVersion();
            String grammarVersion = StringUtils.split((String)version, (char)' ')[1];
            return PythonNature.getGrammarVersionFromStr(grammarVersion);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getGrammarVersionFromStr(String grammarVersion) {
        if ("2.1".equals(grammarVersion)) {
            return 10;
        }
        if ("2.2".equals(grammarVersion)) {
            return 10;
        }
        if ("2.3".equals(grammarVersion)) {
            return 10;
        }
        if ("2.4".equals(grammarVersion)) {
            return 10;
        }
        if ("2.5".equals(grammarVersion)) {
            return 11;
        }
        if ("2.6".equals(grammarVersion)) {
            return 12;
        }
        if ("3.0".equals(grammarVersion)) {
            return 99;
        }
        PydevPlugin.log(new StringBuffer("Unable to recognize version: ").append(grammarVersion).toString());
        return 12;
    }

    protected IPythonNatureStore getStore() {
        return this.pythonNatureStore;
    }

    protected class RebuildPythonNatureModules
    extends Job {
        private String submittedPaths;
        private String submittedInterpreter;

        protected RebuildPythonNatureModules() {
            super("Python Nature: rebuilding modules");
        }

        public synchronized void setParams(String paths, String defaultSelectedInterpreter) {
            this.submittedPaths = paths;
            this.submittedInterpreter = defaultSelectedInterpreter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitorArg) {
            String defaultSelectedInterpreter;
            String paths;
            RebuildPythonNatureModules rebuildPythonNatureModules = this;
            synchronized (rebuildPythonNatureModules) {
                paths = this.submittedPaths;
                defaultSelectedInterpreter = this.submittedInterpreter;
            }
            try {
                JobProgressComunicator jobProgressComunicator = new JobProgressComunicator(monitorArg, "Rebuilding modules", -1, this);
                try {
                    ICodeCompletionASTManager tempAstManager = PythonNature.this.astManager;
                    if (tempAstManager == null) {
                        tempAstManager = new ASTManager();
                    }
                    ICodeCompletionASTManager iCodeCompletionASTManager = tempAstManager;
                    synchronized (iCodeCompletionASTManager) {
                        PythonNature.this.astManager = tempAstManager;
                        tempAstManager.setProject(PythonNature.this.getProject(), (IPythonNature)PythonNature.this, false);
                        tempAstManager.changePythonPath(paths, PythonNature.this.project, (IProgressMonitor)jobProgressComunicator, defaultSelectedInterpreter);
                        PythonNature.this.saveAstManager();
                        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
                        Iterator iterator = participants.iterator();
                        while (iterator.hasNext()) {
                            IInterpreterObserver observer = (IInterpreterObserver)iterator.next();
                            try {
                                observer.notifyProjectPythonpathRestored(PythonNature.this, jobProgressComunicator, defaultSelectedInterpreter);
                            }
                            catch (Exception e) {
                                PydevPlugin.log(e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    PydevPlugin.log(e);
                }
                PythonNature.this.initializationFinished = true;
                PythonNatureListenersManager.notifyPythonPathRebuilt(PythonNature.this.project, PythonNature.this.pythonPathNature.getCompleteProjectPythonPath(null));
                jobProgressComunicator.done();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

