/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.plugin.AbstractPydevPrefs;
import org.python.pydev.plugin.PydevPlugin;

public class PydevPrefs2
extends AbstractPydevPrefs {
    public PydevPrefs2() {
        this.setDescription("Editor");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        Button b = this.addCheckBox(appearanceComposite, "Automatic parentheses insertion", "AUTO_PAR", 0);
        b.setToolTipText(WordUtils.wrap((String)"Enabling this option will enable automatic insertion of parentheses.  Specifically, whenever you hit a brace such as '(', '{', or '[', its related peer will be inserted and your cursor will be placed between the two braces.", (int)80));
        b = this.addCheckBox(appearanceComposite, "After '(' indent to its level (false will indent a single tab)", "AUTO_INDENT_TO_PAR_LEVEL", 0);
        b = this.addCheckBox(appearanceComposite, "Automatic dedent of 'else:' and 'elif:'", "AUTO_DEDENT_ELSE", 0);
        b = this.addCheckBox(appearanceComposite, "Automatically skip matching braces when typing", "AUTO_BRACES", 0);
        b.setToolTipText(WordUtils.wrap((String)"Enabling this option will enable automatically skipping matching braces if you try to insert them.  For example, if you have the following code:\n\ndef function(self):\n\n...with your cursor before the end parenthesis (after the 'f' in \"self\"), typing a ')' will simply move the cursor to the position after the ')' without inserting a new one.", (int)80));
        b = this.addCheckBox(appearanceComposite, "Use smart-indent?", "SMART_INDENT_PAR", 0);
        b = this.addCheckBox(appearanceComposite, "Automatic colon detection", "AUTO_COLON", 0);
        b.setToolTipText(WordUtils.wrap((String)"Enabling this feature will enable the editor to detect if you are trying to enter a colon which is already there.  Instead of inserting another colon, the editor will simply move your cursor to the next position after the colon.", (int)80));
        b = this.addCheckBox(appearanceComposite, "Automatic insertion of the 'import' string on 'from xxx' ", "AUTO_WRITE_IMPORT_STR", 0);
        b.setToolTipText(WordUtils.wrap((String)"Enabling this will allow the editor to automatically write the'import' string when you write a space after you've written 'from xxx '.", (int)80));
        this.addCheckBox(appearanceComposite, "Add 'self' automatically when declaring methods?", "AUTO_ADD_SELF", 0);
        return appearanceComposite;
    }
}

