/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.python.pydev.plugin.AbstractPydevPrefs;
import org.python.pydev.plugin.ColorEditor;
import org.python.pydev.plugin.PydevPlugin;

public class PydevPrefs
extends AbstractPydevPrefs {
    public PydevPrefs() {
        this.setDescription("Pydev editor appearance settings:\nNote: Pydev ignores the 'Insert spaces for tabs' in the general settings.");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        this.addTextField(appearanceComposite, "Tab length:", "TAB_WIDTH", 3, 0, true);
        this.addCheckBox(appearanceComposite, "Replace tabs with spaces when typing?", "SUBSTITUTE_TABS", 0);
        this.addCheckBox(appearanceComposite, "Assume tab spacing when files contain tabs?", "GUESS_TAB_SUBSTITUTION", 0);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText("Appearance color options:");
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText("Color:");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = PydevPrefs.this.fAppearanceColorDefault.getSelection();
                PydevPrefs.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = PydevPrefs.this.fAppearanceColorList.getSelectionIndex();
                String key = PydevPrefs.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    PydevPrefs.this.fOverlayStore.setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText("System default");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PydevPrefs.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PydevPrefs.this.fAppearanceColorList.getSelectionIndex();
                String key = PydevPrefs.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)PydevPrefs.this.fOverlayStore, (String)key, (RGB)PydevPrefs.this.fAppearanceColorEditor.getColorValue());
            }
        });
        this.fFontBoldCheckBox = this.addStyleCheckBox(stylesComposite, "Bold");
        this.fFontItalicCheckBox = this.addStyleCheckBox(stylesComposite, "Italic");
        return appearanceComposite;
    }
}

