/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IPropertyListener;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.PyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPyRefactoring
implements IPyRefactoring {
    private static volatile IPyRefactoring pyRefactoring;
    private static volatile IPyRefactoring defaultPyRefactoring;
    private List<IPropertyListener> propChangeListeners = new ArrayList<IPropertyListener>();
    private Tuple<IPyRefactoring, List<String>> lastRefactorResults;

    public static void firePropertiesChanged() {
        if (defaultPyRefactoring != null) {
            defaultPyRefactoring.firePropertyChange();
        }
        if (pyRefactoring != null && pyRefactoring != defaultPyRefactoring) {
            pyRefactoring.firePropertyChange();
        }
    }

    public static void restartShells() {
        if (defaultPyRefactoring != null) {
            defaultPyRefactoring.restartShell();
        }
        if (pyRefactoring != null && pyRefactoring != defaultPyRefactoring) {
            pyRefactoring.restartShell();
        }
    }

    public static void addPropertiesListener(IPropertyListener listener) {
        if (defaultPyRefactoring != null) {
            defaultPyRefactoring.addPropertyListener(listener);
        }
        if (pyRefactoring != null && pyRefactoring != defaultPyRefactoring) {
            pyRefactoring.addPropertyListener(listener);
        }
    }

    public static synchronized IPyRefactoring getDefaultPyRefactoring() {
        if (defaultPyRefactoring == null) {
            defaultPyRefactoring = new PyRefactoring();
        }
        return defaultPyRefactoring;
    }

    public static synchronized void setPyRefactoring(IPyRefactoring ref) {
        pyRefactoring = ref;
    }

    public static synchronized IPyRefactoring getPyRefactoring() {
        if (pyRefactoring == null) {
            IPyRefactoring r = (IPyRefactoring)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_refactoring");
            pyRefactoring = r != null ? r : AbstractPyRefactoring.getDefaultPyRefactoring();
        }
        return pyRefactoring;
    }

    @Override
    public void setLastRefactorResults(Tuple<IPyRefactoring, List<String>> lastRefactorResults) {
        this.lastRefactorResults = lastRefactorResults;
        this.firePropertyChange();
    }

    @Override
    public void firePropertyChange() {
        if (this.lastRefactorResults != null) {
            for (IPropertyListener element : this.propChangeListeners) {
                element.propertyChanged(this.lastRefactorResults, 1);
            }
        }
    }

    @Override
    public Tuple<IPyRefactoring, List<String>> getLastRefactorResults() {
        return this.lastRefactorResults;
    }

    @Override
    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add(l);
    }

    @Override
    public void checkAvailableForRefactoring(RefactoringRequest request) {
        PyRefactorAction.checkAvailableForRefactoring(request, pyRefactoring);
    }
}

