/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;

public class PyConvertSpaceToTab
extends PyAction {
    private PySelection ps;

    public void run(IAction action) {
        try {
            this.ps = new PySelection(this.getTextEditor());
            this.ps.selectAll(false);
            PyConvertSpaceToTab.perform(this.ps);
            this.getTextEditor().selectAndReveal(this.ps.getLineOffset(), 0);
        }
        catch (Exception e) {
            PyConvertSpaceToTab.beep(e);
        }
    }

    public static boolean perform(PySelection ps) {
        FastStringBuffer strbuf = new FastStringBuffer();
        ps.selectCompleteLine();
        try {
            String tabSpace = PyConvertSpaceToTab.getTabSpace();
            IDocument doc = ps.getDoc();
            int endLineIndex = ps.getEndLineIndex();
            String endLineDelim = ps.getEndLineDelim();
            int i = ps.getStartLineIndex();
            while (i <= endLineIndex) {
                IRegion lineInformation = doc.getLineInformation(i);
                String line = doc.get(lineInformation.getOffset(), lineInformation.getLength());
                strbuf.append(line.replaceAll(tabSpace, "\t")).append(i < endLineIndex ? endLineDelim : "");
                ++i;
            }
            doc.replace(ps.getStartLine().getOffset(), ps.getSelLength(), strbuf.toString());
            return true;
        }
        catch (Exception e) {
            PyConvertSpaceToTab.beep(e);
            return false;
        }
    }

    protected static String getTabSpace() {
        StringBuffer sbuf = new StringBuffer();
        int tabWidth = DefaultIndentPrefs.getStaticTabWidth();
        int i = 0;
        while (i < tabWidth) {
            sbuf.append(" ");
            ++i;
        }
        return sbuf.toString();
    }
}

