/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors.selection;

import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionExtenderVisitor
extends VisitorBase {
    private ModuleAdapter module;
    private ITextSelection selection;
    private FastStack<SimpleNode> stmtExprStack;
    private SimpleNode extendNodeInSelection;

    public SelectionExtenderVisitor(ModuleAdapter module, ITextSelection selection) {
        this.module = module;
        this.selection = selection;
        this.stmtExprStack = new FastStack();
        this.extendNodeInSelection = null;
    }

    public void traverse(SimpleNode node) throws Exception {
        if (node != null) {
            this.updateSelection(node);
            node.traverse((VisitorIF)this);
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    private void updateSelection(SimpleNode node) {
        this.extendSelection(node);
        if (node.beginLine <= this.selection.getEndLine() + 1) {
            this.updateStack(node);
            this.checkAndExtend(node, node);
        } else if (node.beginLine >= this.selection.getEndLine() + 1 && !this.stmtExprStack.isEmpty()) {
            this.extendNodeInSelection = (SimpleNode)this.stmtExprStack.peek();
        }
    }

    protected SimpleNode visit(SimpleNode node) throws Exception {
        if (node == null) {
            return null;
        }
        this.updateSelection(node);
        if (node instanceof suiteType) {
            this.visitSuiteType((suiteType)node);
        } else if (node instanceof excepthandlerType) {
            this.visitExceptionHandler((excepthandlerType)node);
        } else if (node instanceof decoratorsType) {
            this.visitDecoratorsType((decoratorsType)node);
        } else if (node instanceof keywordType) {
            this.visitKeywordType((keywordType)node);
        } else if (node instanceof argumentsType) {
            this.visitArgumentsType((argumentsType)node);
        } else if (node instanceof aliasType) {
            this.visitAliasType((aliasType)node);
        } else {
            node.accept((VisitorIF)this);
        }
        if (this.hasSpecialInSelection(node, node.getSpecialsBefore())) {
            this.extendNodeInSelection = node;
        }
        if (this.hasSpecialInSelection(node, node.getSpecialsAfter())) {
            this.extendNodeInSelection = node;
        }
        return node;
    }

    private boolean hasSpecialInSelection(SimpleNode node, List<Object> specials) {
        for (Object o : specials) {
            Str strNode = this.convertSpecialToStr(o);
            if (strNode == null || !this.module.isNodeInSelection(this.selection, (SimpleNode)strNode)) continue;
            return true;
        }
        return false;
    }

    private Str convertSpecialToStr(Object o) {
        Str stringNode = null;
        if (o instanceof SpecialStr) {
            SpecialStr special = (SpecialStr)o;
            stringNode = new Str(special.str, 4, false, false);
            stringNode.beginLine = special.beginLine;
            stringNode.beginColumn = special.beginCol;
        }
        return stringNode;
    }

    private void extendSelection(SimpleNode node) {
        if (this.extendNodeInSelection != null && this.isExtendable(node) && node != this.extendNodeInSelection) {
            node = this.resolveExtendNode(node);
            this.selection = this.module.extendSelection(this.selection, this.extendNodeInSelection, node);
            this.extendNodeInSelection = null;
            this.stmtExprStack.clear();
        }
    }

    private boolean isExtendable(SimpleNode node) {
        return node instanceof stmtType || node instanceof excepthandlerType || node instanceof suiteType;
    }

    private SimpleNode resolveExtendNode(SimpleNode node) {
        if (this.extendNodeInSelection instanceof exprType) {
            while (!this.stmtExprStack.isEmpty() && !this.isExtendable((SimpleNode)this.stmtExprStack.peek())) {
                this.stmtExprStack.pop();
            }
            if (!this.stmtExprStack.isEmpty()) {
                SimpleNode stmtBefore = (SimpleNode)this.stmtExprStack.peek();
                node = this.checkSpecials(stmtBefore, stmtBefore.getSpecialsAfter());
            }
        }
        node = this.checkSpecials(node, node.getSpecialsBefore());
        return node;
    }

    private SimpleNode checkSpecials(SimpleNode node, List<Object> specials) {
        if (specials.size() > 0) {
            for (Object o : specials) {
                if (!(o instanceof SpecialStr)) continue;
                SpecialStr str = (SpecialStr)o;
                if (str.beginLine < this.extendNodeInSelection.beginLine) continue;
                return this.convertSpecialToStr(o);
            }
        }
        return node;
    }

    private void checkAndExtend(SimpleNode extendNode, SimpleNode checkNode) {
        if (this.module.isNodeInSelection(this.selection, checkNode)) {
            this.extendNodeInSelection = extendNode;
        }
    }

    public Object visitCall(Call node) throws Exception {
        this.traverse((SimpleNode)node);
        this.checkAndExtend((SimpleNode)node, (SimpleNode)node.func);
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.visit((SimpleNode)node.value);
        this.visit((SimpleNode)node.attr);
        this.checkAndExtend((SimpleNode)node, (SimpleNode)node.value);
        this.checkAndExtend((SimpleNode)node, (SimpleNode)node.attr);
        return null;
    }

    public Object visitFor(For node) throws Exception {
        this.visit((SimpleNode)node.target);
        this.visit((SimpleNode)node.iter);
        this.visit((SimpleNode[])node.body);
        this.visit((SimpleNode)node.orelse);
        return null;
    }

    public Object visitWhile(While node) throws Exception {
        this.visit((SimpleNode)node.test);
        this.visit((SimpleNode[])node.body);
        this.visit((SimpleNode)node.orelse);
        return null;
    }

    public Object visitIf(If node) throws Exception {
        this.visit((SimpleNode)node.test);
        this.visit((SimpleNode[])node.body);
        if (node.orelse != null) {
            if (this.extendNodeInSelection instanceof exprType) {
                this.extendSelection((SimpleNode)node);
            }
            this.visit((SimpleNode[])node.orelse);
        }
        return null;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        this.visit((SimpleNode[])node.body);
        this.visit((SimpleNode[])node.handlers);
        this.visit((SimpleNode)node.orelse);
        if (node.orelse != null) {
            if (this.extendNodeInSelection instanceof exprType) {
                this.extendSelection((SimpleNode)node);
            }
            this.visit((SimpleNode)node.orelse);
        }
        return null;
    }

    private Object visitSuiteType(suiteType node) throws Exception {
        this.visit((SimpleNode[])node.body);
        return null;
    }

    private Object visitExceptionHandler(excepthandlerType node) throws Exception {
        this.visit((SimpleNode)node.type);
        this.visit((SimpleNode)node.name);
        this.visit((SimpleNode[])node.body);
        return null;
    }

    private Object visitDecoratorsType(decoratorsType node) throws Exception {
        this.visit((SimpleNode)node.func);
        this.visit((SimpleNode[])node.args);
        this.visit((SimpleNode[])node.keywords);
        this.visit((SimpleNode)node.starargs);
        this.visit((SimpleNode)node.kwargs);
        return null;
    }

    private Object visitKeywordType(keywordType node) throws Exception {
        this.visit((SimpleNode)node.arg);
        this.visit((SimpleNode)node.value);
        return null;
    }

    private Object visitArgumentsType(argumentsType node) throws Exception {
        this.visit((SimpleNode[])node.args);
        this.visit((SimpleNode[])node.defaults);
        this.visit((SimpleNode)node.vararg);
        this.visit((SimpleNode)node.kwarg);
        return null;
    }

    private Object visitAliasType(aliasType node) throws Exception {
        this.visit((SimpleNode)node.name);
        this.visit((SimpleNode)node.asname);
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.visit((SimpleNode)node.name);
        this.visit((SimpleNode)node.args);
        this.visit((SimpleNode[])node.body);
        this.extendLast((SimpleNode)node);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.visit((SimpleNode)node.name);
        this.visit((SimpleNode[])node.bases);
        this.visit((SimpleNode[])node.body);
        this.extendLast((SimpleNode)node);
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.visit((SimpleNode[])node.body);
        this.extendLast((SimpleNode)node);
        return null;
    }

    private void extendLast(SimpleNode node) {
        if (this.extendNodeInSelection != null) {
            this.selection = this.module.extendSelectionToEnd(this.selection, node);
        }
        if (!this.stmtExprStack.isEmpty()) {
            this.selection = this.module.extendSelection(this.selection, (SimpleNode)this.stmtExprStack.peek());
        }
    }

    private void visit(SimpleNode[] body) throws Exception {
        SimpleNode[] simpleNodeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode node = simpleNodeArray[n2];
            this.visit(node);
            ++n2;
        }
    }

    private void updateStack(SimpleNode node) {
        if (!this.stmtExprStack.isEmpty() && node == this.stmtExprStack.peek()) {
            return;
        }
        if (node instanceof stmtType || node instanceof exprType) {
            this.stmtExprStack.push((Object)node);
        }
    }

    public ITextSelection getSelection() {
        return this.selection;
    }
}

