/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.rewriter;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.Ellipsis;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.Expression;
import org.python.pydev.parser.jython.ast.ExtSlice;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.GeneratorExp;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.IfExp;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Interactive;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Repr;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Slice;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.StrJoin;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.listcompType;
import org.python.pydev.parser.jython.ast.modType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.refactoring.ast.printer.SourcePrinter;
import org.python.pydev.refactoring.ast.rewriter.AbstractRewriterVisitor;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriterVisitor
extends AbstractRewriterVisitor {
    public static String reparsed(String source, String string) {
        StringWriter out = new StringWriter();
        RewriterVisitor.createRewriterVisitor(out, source, "\n");
        return out.getBuffer().toString();
    }

    public static String createSourceFromAST(SimpleNode root, boolean ignoreComments, String newLineDelim) {
        RewriterVisitor visitor = null;
        StringWriter writer = new StringWriter();
        try {
            visitor = new RewriterVisitor(VisitorFactory.createPrinter(writer, newLineDelim));
            visitor.setIgnoreComments(ignoreComments);
            visitor.visit(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        visitor.flush();
        return writer.getBuffer().toString();
    }

    public static String createSourceFromAST(SimpleNode root, String newLineDelim) {
        return RewriterVisitor.createSourceFromAST(root, false, newLineDelim);
    }

    private static RewriterVisitor createRewriterVisitor(Writer out, String source, String newLineDelim) {
        RewriterVisitor visitor = new RewriterVisitor(VisitorFactory.createPrinter(out, newLineDelim));
        try {
            SimpleNode root = VisitorFactory.getRootNodeFromString(source);
            root.accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        visitor.flush();
        return visitor;
    }

    private RewriterVisitor(SourcePrinter printer) {
        super(printer);
    }

    private SimpleNode handleCallArguments(Call node) throws Exception {
        SimpleNode lastNode = null;
        lastNode = this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.args);
        if (this.printer.getNodeHelper().isFilledList((SimpleNode[])node.keywords)) {
            lastNode = this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.keywords);
        }
        if (node.starargs != null) {
            lastNode = this.visit((SimpleNode)node.starargs);
        }
        if (node.kwargs != null) {
            if (node.starargs != null) {
                this.printer.printListSeparator();
            }
            lastNode = this.visit((SimpleNode)node.kwargs);
        }
        return lastNode;
    }

    private boolean handleCommaOptional(SimpleNode node) {
        return this.printer.hasSpecialAfter(node, this.printer.getSyntaxhelper().getComma());
    }

    protected void handleCommentAfter(SimpleNode node) {
        this.printer.printCommentAfter(node);
    }

    private void handleCommentAfterBody(SimpleNode node, SimpleNode firstBodyNode) {
        this.printer.printCommentAfterBody(node, firstBodyNode);
    }

    protected void handleCommentBefore(SimpleNode node) {
        this.printer.printCommentBefore(node);
    }

    private void handleCommentBeforeBody(SimpleNode node, SimpleNode firstBodyNode) {
        this.printer.printCommentBeforeBody(node, firstBodyNode);
    }

    private SimpleNode handleDecoratorArgs(decoratorsType node) throws Exception {
        if (node == null) {
            return null;
        }
        SimpleNode lastNode = null;
        if (node.args != null) {
            if (this.isFilledList((SimpleNode[])node.args)) {
                this.printer.printBeforeTuple();
            }
            lastNode = this.visitWithSeparator((SimpleNode)node, this.reverseNodeArray((SimpleNode[])node.args));
            if (this.isFilledList((SimpleNode[])node.keywords)) {
                lastNode = this.visitWithSeparator((SimpleNode)node, this.reverseNodeArray((SimpleNode[])node.keywords));
            }
            if (node.starargs != null) {
                this.printer.printBeforeVarArg();
                super.visit((SimpleNode)node.starargs);
                lastNode = node.starargs;
            }
            if (node.kwargs != null) {
                if (lastNode != null) {
                    this.printer.printListSeparator();
                }
                this.printer.printBeforeKwArg();
                super.visit((SimpleNode)node.kwargs);
                lastNode = node.kwargs;
            }
            if (this.isFilledList((SimpleNode[])node.args)) {
                this.printer.printAfterTuple();
            }
        }
        return lastNode;
    }

    private SimpleNode handleFunctionArgs(SimpleNode node, argumentsType arguments) throws Exception {
        SimpleNode lastNode = null;
        if (arguments != null) {
            lastNode = this.handlePositionalAndDefaultArgs(node, arguments);
            lastNode = this.handleVarArgs(arguments, lastNode);
            lastNode = this.handleKwArgs(arguments, lastNode);
        }
        return lastNode;
    }

    private void handleIfElse(If node) throws Exception {
        boolean passedElsif = false;
        if (node.orelse != null) {
            stmtType[] stmtTypeArray = node.orelse;
            int n = node.orelse.length;
            int n2 = 0;
            while (n2 < n) {
                stmtType statement = stmtTypeArray[n2];
                passedElsif = this.handleIfElseSuite(node, passedElsif, statement);
                ++n2;
            }
            if (passedElsif) {
                this.printer.outdent();
            }
        }
    }

    private boolean handleIfElseSuite(If node, boolean passedElsif, stmtType statement) throws Exception {
        this.printer.setDisabledIfPrinting(true);
        this.printer.printNewlineAndIndentation();
        if (this.printer.getNodeHelper().isIfStatement((SimpleNode)statement)) {
            if (!passedElsif) {
                this.printer.printStatementElif();
            } else {
                this.printer.setDisabledIfPrinting(false);
            }
        } else if (!passedElsif) {
            passedElsif = true;
            this.printer.printStatementElse();
            this.printer.printFunctionMarker();
            this.printer.indent();
            this.printer.printNewlineAndIndentation();
        }
        this.visit((SimpleNode)statement);
        return passedElsif;
    }

    private exprType handleKeyValueArgs(SimpleNode parent, exprType[] keys, exprType[] values) throws Exception {
        exprType lastNode = null;
        if (keys == null) {
            return lastNode;
        }
        int startOffset = 0;
        if (values != null) {
            startOffset = keys.length - values.length;
        }
        int i = 0;
        while (i < keys.length) {
            super.visit((SimpleNode)keys[i]);
            if (values != null && i >= startOffset && values[i - startOffset] != null) {
                if (this.printer.getNodeHelper().isDict(parent)) {
                    this.printer.printDictBeforeValue();
                } else {
                    this.printer.printAssignmentOperator(false, false);
                }
                super.visit((SimpleNode)values[i - startOffset]);
            }
            if (i < keys.length - 1) {
                this.printer.printListSeparator();
            } else {
                lastNode = keys[i];
            }
            ++i;
        }
        return lastNode;
    }

    private SimpleNode handleKwArgs(argumentsType arguments, SimpleNode lastNode) throws Exception {
        if (arguments.kwarg != null) {
            if (lastNode != null) {
                this.printer.printListSeparator();
            }
            this.printer.printBeforeKwArg();
            super.visit((SimpleNode)arguments.kwarg);
            lastNode = arguments.kwarg;
            if (this.handleCommaOptional(lastNode)) {
                this.printer.printListSeparator();
            }
        }
        return lastNode;
    }

    private SimpleNode handlePositionalAndDefaultArgs(SimpleNode node, argumentsType arguments) throws Exception {
        exprType lastNode = this.visitKeyValue(node, arguments.args, arguments.defaults);
        if (this.handleCommaOptional((SimpleNode)lastNode) && arguments.vararg == null && arguments.kwarg == null) {
            this.printer.printListSeparator();
        }
        return lastNode;
    }

    private void handlePostNode(SimpleNode parent, SimpleNode lastNode, Iterator<SimpleNode> iter, boolean outdent, boolean separator, String separatorStr) {
        if (separator) {
            this.handleSeparator(parent, lastNode, iter, separatorStr);
        }
        this.handleCommentAfter(lastNode);
        if (outdent && !iter.hasNext()) {
            this.printer.outdent();
        }
        if (iter.hasNext() && !separator && !this.printer.getNodeHelper().isComprehension(parent)) {
            this.printer.printNewlineAndIndentation();
        }
    }

    private void handlePreNode(SimpleNode parent, SimpleNode lastNode, List<SimpleNode> nodes) {
        this.handleCommentBefore(lastNode);
        if (this.printer.getNodeHelper().isComprehension(parent)) {
            this.printer.printStatementIf(lastNode, true, true);
        }
    }

    private void handleRootNode(modType node, stmtType[] body) throws Exception {
        this.handleCommentBefore((SimpleNode)node);
        this.handleCommentAfter(this.visit((SimpleNode)node, (SimpleNode[])body, false, false));
        this.handleCommentAfter((SimpleNode)node);
    }

    private void handleSeparator(SimpleNode parent, SimpleNode lastNode, Iterator<SimpleNode> iter, String separatorStr) {
        if (iter.hasNext()) {
            if (this.printer.getNodeHelper().isBoolOp(parent)) {
                BoolOp boolParent = (BoolOp)parent;
                this.printer.printBoolOp(boolParent.op);
            } else {
                this.printer.printListSeparator(separatorStr);
            }
        } else if (this.handleCommaOptional(lastNode)) {
            this.printer.printListSeparator(separatorStr);
        }
    }

    private void handleTryBody(stmtType node, stmtType[] body) throws Exception {
        if (!this.printer.getNodeHelper().isTryStatement((SimpleNode)node)) {
            return;
        }
        this.printer.printStatementTry();
        this.printer.printFunctionMarker();
        this.printer.indent();
        if (this.isFilledList((SimpleNode[])body)) {
            this.handleCommentBeforeBody((SimpleNode)node, (SimpleNode)body[0]);
        }
        this.printer.printNewlineAndIndentation();
        if (this.isFilledList((SimpleNode[])body)) {
            this.handleCommentAfterBody((SimpleNode)node, this.visit((SimpleNode)node, (SimpleNode[])body));
        }
    }

    private SimpleNode handleVarArgs(argumentsType arguments, SimpleNode lastNode) throws Exception {
        if (arguments.vararg != null) {
            if (lastNode != null) {
                this.printer.printListSeparator();
            }
            this.printer.printBeforeVarArg();
            super.visit((SimpleNode)arguments.vararg);
            lastNode = arguments.vararg;
            if (this.handleCommaOptional(lastNode) && arguments.kwarg == null) {
                this.printer.printListSeparator();
            }
        }
        return lastNode;
    }

    public boolean isEmptyList(SimpleNode[] list) {
        return this.printer.getNodeHelper().isEmptyList(list);
    }

    public boolean isFilledList(SimpleNode[] list) {
        return this.printer.getNodeHelper().isFilledList(list);
    }

    private SimpleNode[] reverseNodeArray(SimpleNode[] expressions) {
        List<SimpleNode> ifs = Arrays.asList(expressions);
        Collections.reverse(ifs);
        SimpleNode[] ifsInOrder = ifs.toArray(new SimpleNode[0]);
        return ifsInOrder;
    }

    protected void visit(decoratorsType[] decs) throws Exception {
        if (decs == null) {
            return;
        }
        List<decoratorsType> stmts = Arrays.asList(decs);
        for (decoratorsType node : stmts) {
            this.visitDecoratorsType(node);
        }
    }

    @Override
    public SimpleNode visit(SimpleNode node) throws Exception {
        SimpleNode lastNode = null;
        this.handleBeforeNode(node);
        this.handleCommentBefore(node);
        lastNode = super.visitNode(node);
        this.handleCommentAfter(node);
        this.handleAfterNode(node);
        return lastNode;
    }

    private SimpleNode visit(SimpleNode node, SimpleNode[] body) throws Exception {
        return this.visit(node, body, true, false);
    }

    private SimpleNode visit(SimpleNode parent, SimpleNode[] list, boolean outdent, boolean separator) throws Exception {
        return this.visit(parent, list, outdent, separator, null);
    }

    private SimpleNode visit(SimpleNode parent, SimpleNode[] list, boolean outdent, boolean separator, String separatorStr) throws Exception {
        if (list == null) {
            return null;
        }
        SimpleNode lastNode = null;
        List<SimpleNode> nodes = Arrays.asList(list);
        Iterator<SimpleNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            lastNode = iter.next();
            this.handlePreNode(parent, lastNode, nodes);
            super.visit(lastNode);
            this.handlePostNode(parent, lastNode, iter, outdent, separator, separatorStr);
        }
        return lastNode;
    }

    @Override
    public Object visitAliasType(aliasType node) throws Exception {
        SimpleNode lastNode = super.visit((SimpleNode)node.name);
        if (node.asname != null) {
            this.printer.printStatementAs();
            super.visit((SimpleNode)node.asname);
            lastNode = node.asname;
        }
        this.handleCommentAfter(lastNode);
        return lastNode;
    }

    @Override
    public Object visitArgumentsType(argumentsType node) throws Exception {
        SimpleNode lastNode = this.handleFunctionArgs(this.getPreviousNode(), node);
        return lastNode;
    }

    public Object visitAssert(Assert node) throws Exception {
        this.handleCommentBefore((SimpleNode)node.test);
        this.printer.printStatementAssert();
        super.visit((SimpleNode)node.test);
        if (node.msg != null) {
            this.printer.printListSeparator();
            this.visit((SimpleNode)node.msg);
            this.handleCommentAfter((SimpleNode)node.msg);
        } else {
            this.handleCommentAfter((SimpleNode)node.test);
        }
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.targets, " = ");
        this.printer.printAssignmentOperator(!this.inCall(), !this.inCall());
        this.visit((SimpleNode)node.value);
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.visit((SimpleNode)node.value);
        this.printer.printAttributeSeparator();
        this.visit((SimpleNode)node.attr);
        return null;
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        this.visit((SimpleNode)node.target);
        this.printer.printBinOp(node.op, true, false);
        this.printer.printAssignmentOperator(false, true);
        this.visit((SimpleNode)node.value);
        return null;
    }

    public Object visitBinOp(BinOp node) throws Exception {
        if (node.left != null && node.right != null) {
            this.visit((SimpleNode)node.left);
            this.printer.printBinOp(node.op, true, true);
            this.visit((SimpleNode)node.right);
        }
        return null;
    }

    public Object visitBoolOp(BoolOp node) throws Exception {
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.values);
        return null;
    }

    public Object visitBreak(Break node) throws Exception {
        this.printer.printStatementBreak();
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        this.visit((SimpleNode)node.func);
        this.enterCall();
        this.printer.openParentheses((SimpleNode)node);
        this.handleCallArguments(node);
        this.printer.closeParentheses((SimpleNode)node);
        this.leaveCall();
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        SimpleNode lastNode = null;
        this.printer.printClassDef();
        super.visit((SimpleNode)node.name);
        this.printer.setIgnoreComments(true);
        if (this.isFilledList((SimpleNode[])node.bases)) {
            this.printer.printBeforeTuple();
            lastNode = this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.bases);
            this.printer.printAfterTuple();
        }
        this.printer.setIgnoreComments(false);
        this.printer.indent();
        this.printer.printFunctionMarker();
        if (lastNode == null) {
            this.handleCommentAfter((SimpleNode)node.name);
        } else {
            this.handleCommentAfter(lastNode);
        }
        this.printer.printNewlineAndIndentation();
        this.visit((SimpleNode)node, (SimpleNode[])node.body);
        return null;
    }

    public Object visitCompare(Compare node) throws Exception {
        this.visit((SimpleNode)node.left);
        int i = 0;
        while (i < node.ops.length) {
            this.printer.printBeforeAndAfterCmpOp();
            this.printer.printCompOp(node.ops[i]);
            this.printer.printBeforeAndAfterCmpOp();
            this.visit((SimpleNode)node.comparators[i]);
            ++i;
        }
        return null;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        this.printer.printStatementFor(true, true);
        super.visit((SimpleNode)node.target);
        this.printer.printStatementIn();
        super.visit((SimpleNode)node.iter);
        if (this.isFilledList((SimpleNode[])node.ifs)) {
            this.printer.indent();
            this.visit((SimpleNode)node, this.reverseNodeArray((SimpleNode[])node.ifs));
        }
        return null;
    }

    public Object visitContinue(Continue node) throws Exception {
        this.printer.printContinue();
        return null;
    }

    @Override
    public Object visitDecoratorsType(decoratorsType node) throws Exception {
        if (node == null) {
            return null;
        }
        this.printer.printBeforeDecorator();
        super.visit((SimpleNode)node.func);
        SimpleNode lastNode = this.handleDecoratorArgs(node);
        if (lastNode == null) {
            this.handleCommentAfter((SimpleNode)node.func);
        } else {
            this.handleCommentAfter(lastNode);
        }
        this.printer.printNewlineAndIndentation();
        return lastNode;
    }

    public Object visitDelete(Delete node) throws Exception {
        this.printer.printStatementDel();
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.targets);
        return null;
    }

    public Object visitDict(Dict node) throws Exception {
        this.printer.printBeforeDict();
        exprType lastNode = this.visitKeyValue((SimpleNode)node, node.keys, node.values);
        this.printer.printAfterDict();
        this.handleCommentAfter((SimpleNode)lastNode);
        return null;
    }

    public Object visitEllipsis(Ellipsis node) throws Exception {
        this.printer.printEllipsis();
        return null;
    }

    @Override
    public Object visitExceptHandlerType(excepthandlerType node) throws Exception {
        this.printer.printStatementExcept(node.type != null);
        super.visit((SimpleNode)node.type);
        if (node.name != null) {
            this.printer.printListSeparator();
            super.visit((SimpleNode)node.name);
        }
        this.printer.printFunctionMarker();
        this.printer.indent();
        if (this.isFilledList((SimpleNode[])node.body)) {
            this.handleCommentBeforeBody((SimpleNode)node.type, (SimpleNode)node.body[0]);
        }
        this.printer.printNewlineAndIndentation();
        SimpleNode lastNode = this.visit((SimpleNode)node, (SimpleNode[])node.body);
        if (this.isFilledList((SimpleNode[])node.body)) {
            this.handleCommentAfterBody((SimpleNode)node, lastNode);
        }
        return null;
    }

    private void visitExceptionHandlers(TryExcept node) throws Exception {
        if (node.handlers != null) {
            excepthandlerType[] excepthandlerTypeArray = node.handlers;
            int n = node.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                excepthandlerType exceptHandler = excepthandlerTypeArray[n2];
                this.printer.printNewlineAndIndentation();
                this.visitExceptHandlerType(exceptHandler);
                ++n2;
            }
        }
    }

    public Object visitExec(Exec node) throws Exception {
        this.printer.printStatementExec();
        this.visit((SimpleNode)node.body);
        if (node.globals != null) {
            this.printer.printStatementIn();
            this.visit((SimpleNode)node.globals);
            if (node.locals != null) {
                this.printer.printListSeparator();
                this.visit((SimpleNode)node.locals);
            }
        }
        return null;
    }

    public Object visitExpr(Expr node) throws Exception {
        this.visit((SimpleNode)node.value);
        return null;
    }

    public Object visitExpression(Expression node) throws Exception {
        this.visit((SimpleNode)node.body);
        return null;
    }

    public Object visitExtSlice(ExtSlice node) throws Exception {
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.dims);
        return null;
    }

    public Object visitFor(For node) throws Exception {
        this.handleCommentBefore((SimpleNode)node.target);
        this.printer.printStatementFor(false, true);
        this.printer.openParentheses((SimpleNode)node);
        super.visit((SimpleNode)node.target);
        this.printer.closeParentheses((SimpleNode)node);
        this.printer.printStatementIn();
        super.visit((SimpleNode)node.iter);
        this.printer.printFunctionMarker();
        this.handleCommentAfter((SimpleNode)node.iter);
        this.printer.indent();
        this.printer.printNewlineAndIndentation();
        this.visit((SimpleNode)node, (SimpleNode[])node.body);
        this.visitSuiteType(node.orelse);
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        SimpleNode lastNode = null;
        this.visit(node.decs);
        this.handleCommentBefore((SimpleNode)node.name);
        this.printer.printFunctionDef();
        super.visit((SimpleNode)node.name);
        this.enterCall();
        this.printer.printBeforeTuple();
        this.setPreviousNode((SimpleNode)node);
        lastNode = super.visit((SimpleNode)node.args);
        this.setPreviousNode((SimpleNode)node.name);
        this.printer.printAfterTuple();
        this.printer.indent();
        this.printer.printFunctionMarker();
        this.leaveCall();
        if (lastNode == null) {
            this.handleCommentAfter((SimpleNode)node.name);
        } else {
            this.handleCommentAfter(lastNode);
        }
        this.printer.printNewlineAndIndentation();
        this.visit((SimpleNode)node, (SimpleNode[])node.body);
        return null;
    }

    public Object visitGeneratorExp(GeneratorExp node) throws Exception {
        this.printer.openParentheses((SimpleNode)node);
        this.visit((SimpleNode)node.elt);
        this.visit((SimpleNode)node, (SimpleNode[])node.generators, false, false);
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        this.printer.printStatementGlobal();
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.names);
        return null;
    }

    public Object visitIf(If node) throws Exception {
        this.printer.printStatementIf((SimpleNode)node, false, true);
        this.printer.openParentheses((SimpleNode)node);
        super.visit((SimpleNode)node.test);
        this.printer.closeParentheses((SimpleNode)node);
        this.printer.printFunctionMarker();
        this.printer.indent();
        this.handleCommentAfter((SimpleNode)node.test);
        this.printer.printNewlineAndIndentation();
        if (this.isFilledList((SimpleNode[])node.body)) {
            this.handleCommentBeforeBody((SimpleNode)node, (SimpleNode)node.body[0]);
        }
        if (this.isFilledList((SimpleNode[])node.body)) {
            this.handleCommentAfterBody((SimpleNode)node, this.visit((SimpleNode)node, (SimpleNode[])node.body));
        }
        this.handleIfElse(node);
        return null;
    }

    public Object visitIfExp(IfExp node) throws Exception {
        super.visit((SimpleNode)node.body);
        this.printer.printStatementIf((SimpleNode)node, true, true);
        this.printer.openParentheses((SimpleNode)node.test);
        super.visit((SimpleNode)node.test);
        this.printer.closeParentheses((SimpleNode)node.test);
        if (node.orelse != null) {
            this.printer.printStatementElseWithSpace();
            super.visit((SimpleNode)node.orelse);
        }
        return null;
    }

    public Object visitImport(Import node) throws Exception {
        this.printer.printStatementImport();
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.names);
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.handleCommentBefore((SimpleNode)node.module);
        this.printer.printStatementFrom();
        super.visit((SimpleNode)node.module);
        this.printer.printStatementFromImport();
        if (this.isFilledList((SimpleNode[])node.names)) {
            this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.names);
        } else {
            this.printer.printBinOp(3, false, false);
        }
        return null;
    }

    public Object visitIndex(Index node) throws Exception {
        this.visit((SimpleNode)node.value);
        return null;
    }

    public Object visitInteractive(Interactive node) throws Exception {
        this.handleRootNode((modType)node, node.body);
        return null;
    }

    public exprType visitKeyValue(SimpleNode parent, exprType[] keys, exprType[] values) throws Exception {
        return this.handleKeyValueArgs(parent, keys, values);
    }

    @Override
    public Object visitKeywordType(keywordType node) throws Exception {
        SimpleNode lastNode = this.visit((SimpleNode)node.arg);
        this.printer.printAssignmentOperator(false, false);
        if (node.value != null) {
            lastNode = this.visit((SimpleNode)node.value);
        }
        return lastNode;
    }

    public Object visitLambda(Lambda node) throws Exception {
        this.printer.printstatementLambda();
        this.setPreviousNode((SimpleNode)node);
        this.visit((SimpleNode)node.args);
        this.setPreviousNode((SimpleNode)node);
        this.printer.printFunctionMarkerWithSpace();
        this.visit((SimpleNode)node.body);
        return null;
    }

    public Object visitList(org.python.pydev.parser.jython.ast.List node) throws Exception {
        if (this.isFilledList((SimpleNode[])node.elts)) {
            this.handleCommentBefore((SimpleNode)node.elts[0]);
        }
        this.printer.openBracket((SimpleNode)node);
        this.printer.setIgnoreComments(true);
        SimpleNode lastNode = this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.elts);
        this.printer.setIgnoreComments(false);
        this.printer.closeBracket((SimpleNode)node);
        this.handleCommentAfter(lastNode);
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        if (!this.inCall()) {
            this.printer.openParentheses((SimpleNode)node);
        }
        this.printer.openBracket((SimpleNode)node);
        this.visit((SimpleNode)node.elt);
        this.visit((SimpleNode)node, (SimpleNode[])node.generators, false, false);
        this.printer.closeBracket((SimpleNode)node);
        if (!this.inCall()) {
            this.printer.closeParentheses((SimpleNode)node);
        }
        return null;
    }

    @Override
    public Object visitListCompType(listcompType node) throws Exception {
        SimpleNode lastNode = this.visit((SimpleNode)node.target);
        if (node.iter != null) {
            lastNode = this.visit((SimpleNode)node.iter);
        }
        if (this.isFilledList((SimpleNode[])node.ifs)) {
            lastNode = this.visit((SimpleNode)node, (SimpleNode[])node.ifs, false, false);
        }
        return lastNode;
    }

    public Object visitModule(Module node) throws Exception {
        this.handleRootNode((modType)node, node.body);
        return null;
    }

    public Object visitName(Name node) throws Exception {
        this.printer.print(node.id);
        return null;
    }

    public Object visitNameTok(NameTok node) throws Exception {
        this.printer.print(node.id);
        return null;
    }

    public Object visitNum(Num node) throws Exception {
        this.printer.printNum(node);
        return null;
    }

    public Object visitPass(Pass node) throws Exception {
        this.printer.printStatementPass();
        return null;
    }

    public Object visitPrint(Print node) throws Exception {
        this.printer.printStatementPrint();
        if (node.dest != null) {
            this.printer.printDestinationOperator(false, true);
            this.visit((SimpleNode)node.dest);
            if (this.isFilledList((SimpleNode[])node.values)) {
                this.printer.printListSeparator();
            }
        }
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.values);
        return null;
    }

    public Object visitRaise(Raise node) throws Exception {
        this.printer.printStatementRaise(node.type != null);
        this.visit((SimpleNode)node.type);
        if (node.inst != null) {
            this.printer.printListSeparator();
            this.visit((SimpleNode)node.inst);
        }
        if (node.tback != null) {
            this.printer.printListSeparator();
            this.visit((SimpleNode)node.tback);
        }
        return null;
    }

    public Object visitRepr(Repr node) throws Exception {
        this.handleCommentBefore((SimpleNode)node);
        this.printer.printReprQuote();
        super.visit((SimpleNode)node.value);
        this.printer.printReprQuote();
        this.handleCommentAfter((SimpleNode)node);
        return null;
    }

    public Object visitReturn(Return node) throws Exception {
        this.printer.printStatementReturn();
        this.visit((SimpleNode)node.value);
        return null;
    }

    public Object visitSlice(Slice node) throws Exception {
        this.visit((SimpleNode)node.lower);
        this.printer.printFunctionMarker();
        this.visit((SimpleNode)node.upper);
        if (node.step != null) {
            this.printer.printFunctionMarker();
            this.visit((SimpleNode)node.step);
        }
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        this.printer.printStr(node);
        return null;
    }

    public Object visitStrJoin(StrJoin node) throws Exception {
        this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.strs);
        return null;
    }

    public Object visitSubscript(Subscript node) throws Exception {
        this.visit((SimpleNode)node.value);
        this.printer.openBracket((SimpleNode)node);
        this.visit((SimpleNode)node.slice);
        this.printer.closeBracket((SimpleNode)node);
        return null;
    }

    public Object visitSuite(Suite node) throws Exception {
        this.handleRootNode((modType)node, node.body);
        return null;
    }

    @Override
    public Object visitSuiteType(suiteType node) throws Exception {
        if (node != null) {
            if (!this.printer.getNodeHelper().isTryFinallyStatement(this.getPreviousNode())) {
                this.printer.printNewlineAndIndentation();
                this.printer.printStatementElse();
                this.printer.printFunctionMarker();
            }
            if (this.isFilledList((SimpleNode[])node.body)) {
                this.handleCommentBeforeBody((SimpleNode)node, (SimpleNode)node.body[0]);
            }
            this.printer.indent();
            this.printer.printNewlineAndIndentation();
            SimpleNode lastNode = this.visit((SimpleNode)node, (SimpleNode[])node.body);
            if (this.isFilledList((SimpleNode[])node.body)) {
                this.handleCommentAfterBody((SimpleNode)node, lastNode);
            }
        }
        return null;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        this.handleTryBody((stmtType)node, node.body);
        this.visitExceptionHandlers(node);
        this.visitSuiteType(node.orelse);
        return null;
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        this.handleTryBody((stmtType)node, node.body);
        if (node.finalbody != null) {
            this.printer.printNewlineAndIndentation();
            this.handleCommentBefore((SimpleNode)node.finalbody);
            this.printer.printStatementFinally();
            this.printer.printFunctionMarker();
            this.setPreviousNode((SimpleNode)node);
            this.visitSuiteType(node.finalbody);
        }
        return null;
    }

    public Object visitTuple(Tuple node) throws Exception {
        if (this.isFilledList((SimpleNode[])node.elts)) {
            this.handleCommentBefore((SimpleNode)node.elts[0]);
        }
        this.printer.openParentheses((SimpleNode)node);
        this.printer.setIgnoreComments(true);
        SimpleNode lastNode = this.visitWithSeparator((SimpleNode)node, (SimpleNode[])node.elts);
        this.printer.setIgnoreComments(false);
        this.printer.closeParentheses((SimpleNode)node);
        this.handleCommentAfter(lastNode);
        return null;
    }

    public Object visitUnaryOp(UnaryOp node) throws Exception {
        if (node.operand != null) {
            this.printer.printUnaryOp(node.op);
            this.visit((SimpleNode)node.operand);
        }
        return null;
    }

    public Object visitWhile(While node) throws Exception {
        this.printer.printStatementWhile();
        this.printer.openParentheses((SimpleNode)node);
        super.visit((SimpleNode)node.test);
        this.printer.closeParentheses((SimpleNode)node);
        this.printer.printFunctionMarker();
        if (this.isFilledList((SimpleNode[])node.body)) {
            this.handleCommentBeforeBody((SimpleNode)node.test, (SimpleNode)node.body[0]);
        }
        this.printer.indent();
        this.printer.printNewlineAndIndentation();
        this.visit((SimpleNode)node, (SimpleNode[])node.body);
        this.visitSuiteType(node.orelse);
        return null;
    }

    public Object visitWith(With node) throws Exception {
        exprType lastNode = node.context_expr;
        this.printer.printStatementWith();
        this.printer.openParentheses((SimpleNode)node.context_expr);
        super.visit((SimpleNode)node.context_expr);
        this.printer.closeParentheses((SimpleNode)node.context_expr);
        if (node.optional_vars != null) {
            this.printer.printStatementAs();
            super.visit((SimpleNode)node.optional_vars);
            lastNode = node.optional_vars;
        }
        this.printer.printFunctionMarker();
        this.printer.indent();
        this.handleCommentAfter((SimpleNode)lastNode);
        this.printer.printNewlineAndIndentation();
        this.visit((SimpleNode)node, (SimpleNode[])node.body.body);
        return null;
    }

    private SimpleNode visitWithSeparator(SimpleNode parent, SimpleNode[] body, String separator) throws Exception {
        return this.visit(parent, body, false, true, separator);
    }

    private SimpleNode visitWithSeparator(SimpleNode parent, SimpleNode[] body) throws Exception {
        return this.visit(parent, body, false, true);
    }

    public Object visitYield(Yield node) throws Exception {
        this.handleCommentBefore((SimpleNode)node.value);
        this.printer.printStatementYield();
        super.visit((SimpleNode)node.value);
        this.handleCommentAfter((SimpleNode)node.value);
        return null;
    }
}

