/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.editor.codecompletion.revisited.ModulesKeyTreeMap;
import org.python.pydev.editor.codecompletion.revisited.ModulesManagerCache;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JythonModulesManagerUtils;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModuleForZip;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModulesManager
implements IModulesManager,
Serializable {
    private static final boolean DEBUG_BUILD = false;
    private static final boolean DEBUG_IO = false;
    private static final boolean DEBUG_ZIP = false;
    protected volatile transient CompletionCache completionCache = null;
    private volatile transient int completionCacheI = 0;
    protected transient ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeys = new ModulesKeyTreeMap();
    protected static transient ModulesManagerCache cache = ModulesManager.createCache();
    protected transient Set<File> files = new HashSet<File>();
    protected PythonPathHelper pythonPathHelper = new PythonPathHelper();
    private static final long serialVersionUID = 2L;

    public abstract String[] getBuiltins(String var1);

    public synchronized boolean startCompletionCache() {
        if (this.completionCache == null) {
            this.completionCache = new CompletionCache();
        }
        ++this.completionCacheI;
        return true;
    }

    public synchronized void endCompletionCache() {
        --this.completionCacheI;
        if (this.completionCacheI == 0) {
            this.completionCache = null;
        } else if (this.completionCacheI < 0) {
            throw new RuntimeException("Completion cache negative (request unsynched)");
        }
    }

    private static ModulesManagerCache createCache() {
        return new ModulesManagerCache();
    }

    public PythonPathHelper getPythonPathHelper() {
        return this.pythonPathHelper;
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.modulesKeys = new ModulesKeyTreeMap();
        this.files = new HashSet<File>();
        aStream.defaultReadObject();
        Set set = (Set)aStream.readObject();
        for (ModulesKey key : set) {
            this.modulesKeys.put(key, key);
            if (key.file == null) continue;
            this.files.add(key.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream aStream) throws IOException {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            aStream.defaultWriteObject();
            HashSet set = new HashSet(this.modulesKeys.keySet());
            aStream.writeObject(set);
        }
    }

    private void setModules(ModulesKeyTreeMap<ModulesKey, ModulesKey> keys) {
        this.modulesKeys = keys;
    }

    protected Map<ModulesKey, AbstractModule> getModules() {
        throw new RuntimeException("Deprecated");
    }

    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor, String defaultSelectedInterpreter) {
        List<String> pythonpathList = this.pythonPathHelper.setPythonPath(pythonpath);
        ModulesFoundStructure modulesFound = this.pythonPathHelper.getModulesFoundStructure(pythonpathList, monitor);
        ModulesKeyTreeMap<ModulesKey, ModulesKey> keys = new ModulesKeyTreeMap<ModulesKey, ModulesKey>();
        int j = 0;
        FastStringBuffer buffer = new FastStringBuffer();
        Iterator<Map.Entry<File, String>> iterator = modulesFound.regularModules.entrySet().iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            Map.Entry<File, String> entry = iterator.next();
            File f = entry.getKey();
            String m = entry.getValue();
            if (j % 15 == 0) {
                buffer.clear();
                monitor.setTaskName(buffer.append("Module resolved: ").append(m).toString());
                monitor.worked(1);
            }
            if (m != null) {
                ModulesKey modulesKey = new ModulesKey(m, f);
                if (!keys.containsKey(modulesKey)) {
                    keys.put(modulesKey, modulesKey);
                } else if (PythonPathHelper.isValidSourceFile(f.getName())) {
                    keys.put(modulesKey, modulesKey);
                }
            }
            ++j;
        }
        for (ModulesFoundStructure.ZipContents zipContents : modulesFound.zipContents) {
            if (monitor.isCanceled()) break;
            for (String filePathInZip : zipContents.foundFileZipPaths) {
                String modName = StringUtils.stripExtension((String)filePathInZip).replace('/', '.');
                ModulesKeyForZip k = new ModulesKeyForZip(modName, zipContents.zipFile, filePathInZip, true);
                keys.put((ModulesKey)k, (ModulesKey)k);
                if (zipContents.zipContentsType != ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR) continue;
                for (String s : new FullRepIterable(FullRepIterable.getWithoutLastPart((String)modName))) {
                    k = new ModulesKeyForZip(s, zipContents.zipFile, s.replace('.', '/'), false);
                    keys.put((ModulesKey)k, (ModulesKey)k);
                }
            }
        }
        this.onChangePythonpath(defaultSelectedInterpreter, keys);
        this.setModules(keys);
    }

    protected void onChangePythonpath(String defaultSelectedInterpreter, SortedMap<ModulesKey, ModulesKey> keys) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveSingleModule(ModulesKey key) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            this.modulesKeys.remove(key);
            cache.remove(key, this);
        }
    }

    protected void removeThem(Collection<ModulesKey> toRem) {
        Iterator<ModulesKey> iter = toRem.iterator();
        while (iter.hasNext()) {
            this.doRemoveSingleModule(iter.next());
        }
    }

    public void removeModules(Collection<ModulesKey> toRem) {
        this.removeThem(toRem);
    }

    public IModule addModule(ModulesKey key) {
        AbstractModule ret = AbstractModule.createEmptyModule(key);
        this.doAddSingleModule(key, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            this.modulesKeys.put(key, key);
            cache.add(key, n, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        HashSet<String> s = new HashSet<String>();
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (!key.hasPartStartingWith(partStartingWithLowerCase)) continue;
                s.add(key.name);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ModulesKey, ModulesKey> getAllDirectModulesStartingWith(String strStartingWith) {
        if (strStartingWith.length() == 0) {
            return this.modulesKeys;
        }
        ModulesKey startingWith = new ModulesKey(strStartingWith, null);
        ModulesKey endingWith = new ModulesKey(new StringBuffer().append(startingWith).append("z").toString(), null);
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            return new ModulesKeyTreeMap<ModulesKey, ModulesKey>(this.modulesKeys.subMap(startingWith, endingWith));
        }
    }

    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        return this.getAllDirectModulesStartingWith(strStartingWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesKey[] getOnlyDirectModules() {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            return this.modulesKeys.keySet().toArray(new ModulesKey[0]);
        }
    }

    public int getSize(boolean addDependenciesSize) {
        return this.modulesKeys.size();
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.getModule(true, name, nature, dontSearchInit);
    }

    protected IModule getModule(boolean acceptCompiledModule, String name, IPythonNature nature, boolean dontSearchInit) {
        SourceModule sourceModule;
        SourceModule s;
        AbstractModule n = null;
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        if (!dontSearchInit && n == null) {
            keyForCacheAccess.name = new StringBuffer(name).append(".__init__").toString();
            n = cache.getObj(keyForCacheAccess, this);
            if (n != null) {
                name = new StringBuffer(String.valueOf(name)).append(".__init__").toString();
            }
        }
        if (n == null) {
            keyForCacheAccess.name = name;
            n = cache.getObj(keyForCacheAccess, this);
        }
        if (n instanceof SourceModule && !(s = (SourceModule)n).isSynched()) {
            n = (AbstractModule)this.addModule(this.createModulesKey(s.getName(), s.getFile()));
        }
        if (n instanceof EmptyModule) {
            EmptyModule e = (EmptyModule)n;
            boolean found = false;
            if (!found && e.f != null) {
                if (!e.f.exists()) {
                    keyForCacheAccess.name = name;
                    keyForCacheAccess.file = e.f;
                    this.doRemoveSingleModule(keyForCacheAccess);
                    n = null;
                } else if (e instanceof EmptyModuleForZip) {
                    EmptyModuleForZip emptyModuleForZip = (EmptyModuleForZip)e;
                    if (emptyModuleForZip.pathInZip.endsWith(".class") || !emptyModuleForZip.isFile) {
                        n = JythonModulesManagerUtils.createModuleFromJar(emptyModuleForZip);
                    } else if (FileTypesPreferencesPage.isValidDll(emptyModuleForZip.pathInZip)) {
                        n = new CompiledModule(name, 4, nature.getAstManager());
                    } else if (PythonPathHelper.isValidSourceFile(emptyModuleForZip.pathInZip)) {
                        try {
                            IDocument doc = REF.getDocFromZip((File)emptyModuleForZip.f, (String)emptyModuleForZip.pathInZip);
                            n = AbstractModule.createModuleFromDoc(name, emptyModuleForZip.f, doc, nature, -1, false);
                            SourceModule zipModule = (SourceModule)n;
                            zipModule.zipFilePath = emptyModuleForZip.pathInZip;
                        }
                        catch (Exception exc1) {
                            PydevPlugin.log(exc1);
                            n = null;
                        }
                    }
                } else {
                    try {
                        n = AbstractModule.createModule(name, e.f, nature, -1);
                    }
                    catch (IOException iOException) {
                        keyForCacheAccess.name = name;
                        keyForCacheAccess.file = e.f;
                        this.doRemoveSingleModule(keyForCacheAccess);
                        n = null;
                    }
                }
            } else if (acceptCompiledModule) {
                n = new CompiledModule(name, 4, nature.getAstManager());
            } else {
                return null;
            }
            if (n != null) {
                this.doAddSingleModule(this.createModulesKey(name, e.f), n);
            } else {
                System.err.println(new StringBuffer("The module ").append(name).append(" could not be found nor created!").toString());
            }
        }
        if (n instanceof EmptyModule) {
            throw new RuntimeException("Should not be an empty module anymore!");
        }
        if (n instanceof SourceModule && (sourceModule = (SourceModule)n).isBootstrapModule()) {
            n = new CompiledModule(name, 4, nature.getAstManager());
        }
        return n;
    }

    private ModulesKey createModulesKey(String name, File f) {
        ModulesKey newEntry = new ModulesKey(name, f);
        ModulesKeyTreeMap.Entry<ModulesKey, ModulesKey> oldEntry = this.modulesKeys.getEntry(newEntry);
        if (oldEntry != null) {
            return oldEntry.getKey();
        }
        return newEntry;
    }

    public void clearCache() {
        ModulesManager.cache.internalCache.clear();
    }

    public boolean isInPythonPath(IResource member, IProject container) {
        return this.resolveModule(member, container) != null;
    }

    public String resolveModule(IResource member, IProject container) {
        File inOs = member.getRawLocation().toFile();
        return this.resolveModule(REF.getFileAbsolutePath((File)inOs));
    }

    protected String getResolveModuleErr(IResource member) {
        return new StringBuffer("Unable to find the path ").append(member).append(" in the project were it\n").append("is added as a source folder for pydev.").append(this.getClass()).toString();
    }

    public String resolveModule(String full) {
        return this.pythonPathHelper.resolveModule(full, false);
    }

    public List<String> getPythonPath() {
        return this.pythonPathHelper.getPythonpath();
    }

    public /* synthetic */ Object getPythonPathHelper() {
        return this.getPythonPathHelper();
    }

    protected static class CompletionCache {
        public IModulesManager[] referencedManagers;
        public IModulesManager[] referredManagers;

        protected CompletionCache() {
        }

        public IModulesManager[] getManagers(boolean referenced) {
            if (referenced) {
                return this.referencedManagers;
            }
            return this.referredManagers;
        }

        public void setManagers(IModulesManager[] ret, boolean referenced) {
            if (referenced) {
                this.referencedManagers = ret;
            } else {
                this.referredManagers = ret;
            }
        }
    }
}

