/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.GetVariableCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.plugin.PydevPlugin;

public class PyVariableCollection
extends PyVariable
implements ICommandResponseListener,
IVariableLocator {
    PyVariable[] variables = new PyVariable[0];
    IVariable[] waitVariables = null;
    static final int NETWORK_REQUEST_NOT_REQUESTED = 0;
    static final int NETWORK_REQUEST_NOT_ARRIVED = 1;
    static final int NETWORK_REQUEST_ARRIVED = 2;
    int networkState = 0;
    private boolean fireChangeEvent = true;

    public PyVariableCollection(AbstractDebugTarget target, String name, String type, String value, IVariableLocator locator) {
        super(target, name, type, value, locator);
    }

    public String getDetailText() throws DebugException {
        return super.getDetailText();
    }

    private IVariable[] getWaitVariables() {
        if (this.waitVariables == null) {
            PyVariable waitVar = new PyVariable(this.target, "wait", "", "for network", this.locator);
            this.waitVariables = new IVariable[1];
            this.waitVariables[0] = waitVar;
        }
        return this.waitVariables;
    }

    public IVariable[] getTimedoutVariables() {
        return new IVariable[]{new PyVariable(this.target, "err:", "", "Timed out while getting var.", this.locator)};
    }

    public void commandComplete(AbstractDebuggerCommand cmd) {
        this.variables = this.getCommandVariables(cmd);
        this.networkState = 2;
        if (this.fireChangeEvent) {
            this.target.fireEvent(new DebugEvent((Object)this, 16, 256));
        }
    }

    public PyVariable[] getCommandVariables(AbstractDebuggerCommand cmd) {
        return PyVariableCollection.getCommandVariables(cmd, this.target, this);
    }

    public static PyVariable[] getCommandVariables(AbstractDebuggerCommand cmd, AbstractDebugTarget target, IVariableLocator locator) {
        PyVariable[] tempVariables;
        block2: {
            tempVariables = new PyVariable[]{};
            try {
                String payload = ((GetVariableCommand)cmd).getResponse();
                tempVariables = XMLUtils.XMLToVariables(target, locator, payload);
            }
            catch (CoreException e) {
                tempVariables = new PyVariable[]{new PyVariable(target, "Error", "pydev ERROR", "Could not resolve variable", locator)};
                String msg = e.getMessage();
                if (msg.indexOf("Error resolving frame:") != -1 || msg.indexOf("from thread:") != -1) break block2;
                PydevDebugPlugin.log(4, "Error fetching a variable", e);
            }
        }
        return tempVariables;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.networkState == 2) {
            return this.variables;
        }
        if (this.networkState == 1) {
            return this.getWaitVariables();
        }
        AbstractRemoteDebugger dbg = this.getDebugger();
        GetVariableCommand cmd = this.getVariableCommand(dbg);
        cmd.setCompletionListener(this);
        this.networkState = 1;
        this.fireChangeEvent = false;
        dbg.postCommand(cmd);
        try {
            int i = 10;
            while (--i > 0 && this.networkState != 2) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException e) {
            PydevPlugin.log((Throwable)e);
        }
        this.fireChangeEvent = true;
        if (this.networkState == 2) {
            return this.variables;
        }
        return this.getWaitVariables();
    }

    public AbstractRemoteDebugger getDebugger() {
        return this.target.getDebugger();
    }

    public GetVariableCommand getVariableCommand(AbstractRemoteDebugger dbg) {
        return new GetVariableCommand(dbg, this.getPyDBLocation());
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }
}

