/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.python.pydev.core.docutils.PySelection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String format(String str, Object ... args) {
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '%' && i + 1 < str.length()) {
                char nextC = str.charAt(i + 1);
                if (nextC == 's') {
                    buffer.append(args[j]);
                    ++j;
                    ++i;
                } else if (nextC == '%') {
                    buffer.append('%');
                    ++j;
                    ++i;
                }
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int countPercS(String str) {
        int j = 0;
        int i = 0;
        while (i < str.length()) {
            char nextC;
            char c = str.charAt(i);
            if (c == '%' && i + 1 < str.length() && (nextC = str.charAt(i + 1)) == 's') {
                ++j;
                ++i;
            }
            ++i;
        }
        return j;
    }

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        char[] val = input.toCharArray();
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftTrim(String input) {
        int len = input.length();
        int off = 0;
        char[] val = input.toCharArray();
        while (off < len && val[off] <= ' ') {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String stripExtension(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '.');
    }

    private static String stripFromRigthCharOnwards(String input, char ch) {
        int len = input.length();
        int st = 0;
        int off = 0;
        char[] val = input.toCharArray();
        while (st < len && val[off + len - 1] != ch) {
            --len;
        }
        if (--len == -1) {
            return input;
        }
        return input.substring(0, len);
    }

    public static String stripFromLastSlash(String input) {
        return StringUtils.stripFromRigthCharOnwards(input, '/');
    }

    public static String rightTrim(String input, char charToTrim) {
        int len = input.length();
        int st = 0;
        int off = 0;
        char[] val = input.toCharArray();
        while (st < len && val[off + len - 1] == charToTrim) {
            --len;
        }
        return input.substring(0, len);
    }

    public static String leftTrim(String input, char charToTrim) {
        int len = input.length();
        int off = 0;
        char[] val = input.toCharArray();
        while (off < len && val[off] == charToTrim) {
            ++off;
        }
        return input.substring(off, len);
    }

    public static String replaceAllSlashes(String string) {
        int len = string.length();
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == '\\') {
                char[] ds = string.toCharArray();
                ds[i] = 47;
                int j = i;
                while (j < len) {
                    if (ds[j] == '\\') {
                        ds[j] = 47;
                    }
                    ++j;
                }
                return new String(ds);
            }
            ++i;
        }
        return string;
    }

    public static List<String> splitInLines(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                    buf.append('\n');
                }
                ret.add(buf.toString());
                buf = new StringBuffer();
            }
            if (c == '\n') {
                ret.add(buf.toString());
                buf = new StringBuffer();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    public static boolean isSingleWord(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isJavaIdentifierStart(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String replaceAll(String string, String replace, String with) {
        StringBuffer ret = new StringBuffer();
        int len = string.length();
        int replaceLen = replace.length();
        int i = 0;
        while (i < len) {
            if (i + replaceLen > len) {
                ret.append(string.charAt(i));
            } else {
                String s = string.substring(i, i + replaceLen);
                if (s.equals(replace)) {
                    ret.append(with);
                    i = i + replaceLen - 1;
                } else {
                    ret.append(s.charAt(0));
                }
            }
            ++i;
        }
        return ret.toString();
    }

    public static String removeWhitespaceColumnsToLeft(String hoverInfo) {
        StringBuffer buf = new StringBuffer();
        int firstCharPosition = Integer.MAX_VALUE;
        List<String> splitted = StringUtils.splitInLines(hoverInfo);
        for (String line : splitted) {
            if (line.trim().length() <= 0) continue;
            int found = PySelection.getFirstCharPosition(line);
            firstCharPosition = Math.min(found, firstCharPosition);
        }
        if (firstCharPosition != Integer.MAX_VALUE) {
            for (String line : splitted) {
                if (line.length() <= firstCharPosition) continue;
                buf.append(line.substring(firstCharPosition));
            }
            return buf.toString();
        }
        return hoverInfo;
    }

    public static String extractTextFromHTML(String html) {
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            Document doc = ((EditorKit)kit).createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            StringReader rd = new StringReader(html);
            ((EditorKit)kit).read(rd, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String[] split(String string, char toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String[] dotSplit(String string) {
        return StringUtils.split(string, '.');
    }
}

