/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.ImportNotRecognizedException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportHandle {
    public IDocument doc;
    public String importFound;
    public int startFoundLine;
    public int endFoundLine;
    private List<ImportHandleInfo> importInfo;

    public ImportHandle(IDocument doc, String importFound, int startFoundLine, int endFoundLine) {
        this.doc = doc;
        this.importFound = importFound;
        this.startFoundLine = startFoundLine;
        this.endFoundLine = endFoundLine;
    }

    public boolean contains(ImportHandleInfo otherImportInfo) throws ImportNotRecognizedException {
        List<ImportHandleInfo> importHandleInfo = this.getImportInfo();
        for (ImportHandleInfo info : importHandleInfo) {
            if (info.fromStr != otherImportInfo.fromStr && (otherImportInfo.fromStr == null || info.fromStr == null || !otherImportInfo.fromStr.equals(info.fromStr)) || otherImportInfo.importedStr.size() != 1 || !info.importedStr.contains(otherImportInfo.importedStr.get(0))) continue;
            return true;
        }
        return false;
    }

    public List<ImportHandleInfo> getImportInfo() {
        if (this.importInfo == null) {
            this.importInfo = new ArrayList<ImportHandleInfo>();
            int line = this.startFoundLine;
            boolean startedInMiddle = false;
            FastStringBuffer imp = new FastStringBuffer();
            int i = 0;
            while (i < this.importFound.length()) {
                char c = this.importFound.charAt(i);
                if (c == '#') {
                    i = ParsingUtils.eatComments(this.importFound, imp, i);
                } else if (c == ';') {
                    try {
                        String impStr = imp.toString();
                        int endLine = line + PySelection.countLineBreaks(impStr);
                        this.importInfo.add(new ImportHandleInfo(impStr, line, endLine, startedInMiddle));
                        line = endLine;
                    }
                    catch (ImportNotRecognizedException importNotRecognizedException) {}
                    imp = imp.clear();
                    startedInMiddle = true;
                } else {
                    if (c == '\r' || c == '\n') {
                        startedInMiddle = false;
                    }
                    imp.append(c);
                }
                ++i;
            }
            try {
                String impStr = imp.toString();
                this.importInfo.add(new ImportHandleInfo(impStr, line, line + PySelection.countLineBreaks(impStr), startedInMiddle));
            }
            catch (ImportNotRecognizedException importNotRecognizedException) {}
        }
        return this.importInfo;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportHandleInfo {
        private static final Pattern FromImportPattern = Pattern.compile("(from\\s+)(\\.*\\w+)+(\\s+import\\s+)");
        private static final Pattern ImportPattern = Pattern.compile("(import\\s+)");
        private String fromStr;
        private List<String> importedStr;
        private List<String> importedStrComments;
        private int startLine;
        private int endLine;
        private boolean startedInMiddleOfLine;

        public ImportHandleInfo(String importFound) throws ImportNotRecognizedException {
            this(importFound, -1, -1, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ImportHandleInfo(String importFound, int lineStart, int lineEnd, boolean startedInMiddleOfLine) throws ImportNotRecognizedException {
            this.startLine = lineStart;
            this.endLine = lineEnd;
            this.startedInMiddleOfLine = startedInMiddleOfLine;
            importFound = importFound.trim();
            char firstChar = importFound.charAt(0);
            if (firstChar == 'f') {
                Matcher matcher = FromImportPattern.matcher(importFound);
                if (!matcher.find()) throw new ImportNotRecognizedException(new StringBuffer("Could not recognize import: ").append(importFound).toString());
                this.fromStr = importFound.substring(matcher.end(1), matcher.end(2)).trim();
                String importedStr = importFound.substring(matcher.end(3), importFound.length()).trim();
                this.buildImportedList(importedStr);
                return;
            } else {
                if (firstChar != 'i') throw new ImportNotRecognizedException(new StringBuffer("Could not recognize import: ").append(importFound).toString());
                Matcher matcher = ImportPattern.matcher(importFound);
                if (!matcher.find()) throw new ImportNotRecognizedException(new StringBuffer("Could not recognize import: ").append(importFound).toString());
                String importedStr = importFound.substring(matcher.end(1), importFound.length()).trim();
                this.buildImportedList(importedStr);
            }
        }

        private void buildImportedList(String importedStr) {
            ArrayList<String> lst = new ArrayList<String>();
            ArrayList<String> importComments = new ArrayList<String>();
            FastStringBuffer alias = new FastStringBuffer();
            FastStringBuffer comments = new FastStringBuffer();
            int i = 0;
            while (i < importedStr.length()) {
                char c = importedStr.charAt(i);
                if (c == '#') {
                    comments = comments.clear();
                    i = ParsingUtils.eatComments(importedStr, comments, i);
                    this.addImportAlias(lst, importComments, alias, comments.toString());
                    alias = alias.clear();
                } else if (c == ',' || c == '\r' || c == '\n') {
                    this.addImportAlias(lst, importComments, alias, "");
                    alias = alias.clear();
                } else if (c != '(' && c != ')' && c != '\\') {
                    alias.append(c);
                }
                ++i;
            }
            if (alias.length() > 0) {
                this.addImportAlias(lst, importComments, alias, "");
            }
            this.importedStrComments = importComments;
            this.importedStr = lst;
        }

        private void addImportAlias(ArrayList<String> lst, ArrayList<String> importComments, FastStringBuffer alias, String importComment) {
            String aliasStr = alias.toString().trim();
            importComment = importComment.trim();
            if (aliasStr.length() > 0) {
                lst.add(aliasStr);
                importComments.add(importComment);
            } else if (importComment.length() > 0 && importComments.size() > 0) {
                importComments.set(importComments.size() - 1, importComment);
            }
        }

        public String getFromImportStr() {
            return this.fromStr;
        }

        public List<String> getImportedStr() {
            return this.importedStr;
        }

        public List<String> getCommentsForImports() {
            return this.importedStrComments;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public boolean getStartedInMiddleOfLine() {
            return this.startedInMiddleOfLine;
        }

        public List<Tuple<String, String>> getImportedStrAndComments() {
            ArrayList<Tuple<String, String>> lst = new ArrayList<Tuple<String, String>>();
            int i = 0;
            while (i < this.importedStr.size()) {
                lst.add(new Tuple<String, String>(this.importedStr.get(i), this.importedStrComments.get(i)));
                ++i;
            }
            return lst;
        }
    }
}

