/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.operatorType;

public class BinOp
extends exprType
implements operatorType {
    public exprType left;
    public int op;
    public exprType right;

    public BinOp(exprType left, int op, exprType right) {
        this.left = left;
        this.op = op;
        this.right = right;
    }

    public BinOp(exprType left, int op, exprType right, SimpleNode parent) {
        this(left, op, right);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BinOp[");
        sb.append("left=");
        sb.append(this.dumpThis(this.left));
        sb.append(", ");
        sb.append("op=");
        sb.append(this.dumpThis(this.op, operatorType.operatorTypeNames));
        sb.append(", ");
        sb.append("right=");
        sb.append(this.dumpThis(this.right));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(31, ostream);
        this.pickleThis(this.left, ostream);
        this.pickleThis(this.op, ostream);
        this.pickleThis(this.right, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitBinOp(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.left != null) {
            this.left.accept(visitor);
        }
        if (this.right != null) {
            this.right.accept(visitor);
        }
    }
}

