/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.dialogs.ProjectFolderSelectionDialog;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class TreeWithAddRemove
extends Composite {
    private Tree tree;
    private IProject project;
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;

    public TreeWithAddRemove(Composite parent, int style, IProject project, String initialItems) {
        super(parent, style);
        if (initialItems == null) {
            initialItems = "";
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.project = project;
        this.tree = new Tree((Composite)this, 2048);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)data);
        Composite buttonsSourceFolders = new Composite((Composite)this, 0);
        buttonsSourceFolders.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonsSourceFolders.setLayout((Layout)layout);
        Button buttonAddSourceFolder = new Button(buttonsSourceFolders, 8);
        this.customizeAddSourceFolderButton(buttonAddSourceFolder, true);
        buttonAddSourceFolder.setText(this.getButtonAddText());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        buttonAddSourceFolder.setLayoutData((Object)data);
        Button buttonAddZip = new Button(buttonsSourceFolders, 8);
        this.customizeAddSourceFolderButton(buttonAddZip, false);
        buttonAddZip.setText("Add zip/jar/egg");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        buttonAddZip.setLayoutData((Object)data);
        Button buttonRemSourceFolder = new Button(buttonsSourceFolders, 8);
        this.customizeRemSourceFolderButton(buttonRemSourceFolder);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        buttonRemSourceFolder.setLayoutData((Object)data);
        String[] its = PythonNature.getStrAsStrItems(initialItems);
        int i = 0;
        while (i < its.length) {
            this.addTreeItem(its[i]);
            ++i;
        }
    }

    protected void customizeRemSourceFolderButton(Button buttonRem) {
        buttonRem.setText(this.getButtonRemoveText());
        buttonRem.setToolTipText("Remove the selected item");
        buttonRem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection = TreeWithAddRemove.this.tree.getSelection();
                int i = 0;
                while (i < selection.length) {
                    selection[i].dispose();
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void customizeAddSourceFolderButton(Button buttonAddSourceFolder, final boolean chooseSourceFolder) {
        buttonAddSourceFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object d = chooseSourceFolder ? TreeWithAddRemove.this.getSelectionDialogAddSourceFolder() : TreeWithAddRemove.this.getSelectionDialogAddZip();
                if (d instanceof FileDialog) {
                    FileDialog dialog = (FileDialog)d;
                    dialog.setFilterPath(lastFileDialogPath);
                    String filePath = dialog.open();
                    if (filePath != null) {
                        lastFileDialogPath = filePath;
                    }
                    TreeWithAddRemove.this.addTreeItem(filePath);
                } else if (d instanceof DirectoryDialog) {
                    DirectoryDialog dialog = (DirectoryDialog)d;
                    dialog.setFilterPath(lastDirectoryDialogPath);
                    String filePath = dialog.open();
                    if (filePath != null) {
                        lastDirectoryDialogPath = filePath;
                    }
                    TreeWithAddRemove.this.addTreeItem(filePath);
                } else if (d instanceof SelectionDialog) {
                    SelectionDialog dialog = (SelectionDialog)d;
                    dialog.open();
                    Object[] objects = dialog.getResult();
                    if (objects != null) {
                        int i = 0;
                        while (i < objects.length) {
                            String pathAsString;
                            IPath p;
                            Object object = objects[i];
                            if (object instanceof IPath) {
                                p = (IPath)object;
                                pathAsString = TreeWithAddRemove.this.getPathAsString(p);
                                TreeWithAddRemove.this.addTreeItem(pathAsString);
                            } else if (object instanceof IFile) {
                                p = (IFile)object;
                                pathAsString = TreeWithAddRemove.this.getPathAsString(p.getProjectRelativePath());
                                pathAsString = "/" + p.getProject().getName() + pathAsString;
                                if (FileTypesPreferencesPage.isValidZipFile(pathAsString)) {
                                    TreeWithAddRemove.this.addTreeItem(pathAsString);
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    throw new RuntimeException("Dont know how to treat dialog: " + d.getClass());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected String getButtonRemoveText() {
        return "Remove";
    }

    protected String getButtonAddText() {
        return "Add source folder";
    }

    protected String getImageConstant() {
        return "icons/packagefolder_obj.gif";
    }

    protected Object getSelectionDialogAddZip() {
        return new ResourceSelectionDialog(this.getShell(), (IAdaptable)this.project, "Choose zip/jar/egg to add to PYTHONPATH");
    }

    protected Object getSelectionDialogAddSourceFolder() {
        return new ProjectFolderSelectionDialog(this.getShell(), this.project, true, "Choose source folders to add to PYTHONPATH");
    }

    protected String getPathAsString(IPath p) {
        String ret = p.toString();
        if (!ret.startsWith("/")) {
            ret = "/" + ret;
        }
        return ret;
    }

    private void addTreeItem(String pathAsString) {
        if (pathAsString != null && pathAsString.trim().length() > 0) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(pathAsString);
            item.setImage(PydevPlugin.getImageCache().get(this.getImageConstant()));
        }
    }

    public String getTreeItemsAsStr() {
        StringBuffer ret = new StringBuffer();
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            String text = items[i].getText();
            if (text != null && text.trim().length() > 0) {
                ret.append(text);
                ret.append("|");
            }
            ++i;
        }
        return ret.toString();
    }
}

