/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.filters;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.navigator.properties.StringMatcherSimple;
import org.python.pydev.plugin.PydevPlugin;

public class CustomFilters
extends ViewerFilter {
    private StringMatcherSimple[] filters;

    public CustomFilters() {
        IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
        this.update(prefs.getString("org.python.pydev.CUSTOM_PACKAGE_EXPLORER_FILTERS"));
        new PropertyListener(this);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IAdaptable adaptable;
        Object adapted;
        if (element instanceof IAdaptable && (adapted = (adaptable = (IAdaptable)element).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"))) instanceof IResource) {
            IResource resource = (IResource)adapted;
            String name = resource.getName();
            StringMatcherSimple[] temp = this.filters;
            int i = 0;
            while (i < temp.length) {
                if (temp[i].match(name)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void update(String customFilters) {
        String[] splittedCustomFilters = FullRepIterable.split((String)customFilters, (char)',');
        StringMatcherSimple[] temp = new StringMatcherSimple[splittedCustomFilters.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new StringMatcherSimple(splittedCustomFilters[i].trim());
            ++i;
        }
        this.filters = temp;
    }

    private static class PropertyListener
    implements IPropertyChangeListener {
        private WeakReference<CustomFilters> weakCustomFilter;

        public PropertyListener(CustomFilters customFilter) {
            this.weakCustomFilter = new WeakReference<CustomFilters>(customFilter);
            IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
            prefs.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            CustomFilters customFilters = (CustomFilters)((Object)this.weakCustomFilter.get());
            if (customFilters == null) {
                IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
                prefs.removePropertyChangeListener((IPropertyChangeListener)this);
            } else {
                String property = event.getProperty();
                if (property.equals("org.python.pydev.CUSTOM_PACKAGE_EXPLORER_FILTERS")) {
                    customFilters.update((String)event.getNewValue());
                }
            }
        }
    }
}

