/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.texteditor.spelling.NoCompletionsProposal;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.correctionassist.docstrings.AssistDocString;
import org.python.pydev.editor.correctionassist.heuristics.AssistAssign;
import org.python.pydev.editor.correctionassist.heuristics.AssistImport;
import org.python.pydev.editor.correctionassist.heuristics.AssistSurroundWith;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;
import org.python.pydev.plugin.PydevPlugin;

public class PythonCorrectionProcessor
implements IQuickAssistProcessor {
    private PyEdit edit;
    private static Map<String, IAssistProps> additionalAssists = new HashMap<String, IAssistProps>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            return additionalAssists.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdditionalAssist(String id, IAssistProps assist) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.put(id, assist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.remove(id);
        }
    }

    public PythonCorrectionProcessor(PyEdit edit) {
        this.edit = edit;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        Object prop;
        int offset = invocationContext.getOffset();
        PySelection ps = new PySelection((ITextEditor)this.edit);
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        String sel = PyAction.getLineWithoutComments(ps);
        ArrayList<IAssistProps> assists = new ArrayList<IAssistProps>();
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            Iterator<IAssistProps> iterator = additionalAssists.values().iterator();
            while (iterator.hasNext()) {
                prop = iterator.next();
                assists.add((IAssistProps)prop);
            }
        }
        assists.add(new AssistSurroundWith());
        assists.add(new AssistImport());
        assists.add(new AssistDocString());
        assists.add(new AssistAssign());
        assists.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_ctrl_1"));
        prop = assists.iterator();
        while (prop.hasNext()) {
            IAssistProps assist = (IAssistProps)prop.next();
            try {
                if (!assist.isValid(ps, sel, this.edit, offset)) continue;
                try {
                    results.addAll(assist.getProps(ps, PydevPlugin.getImageCache(), this.edit.getEditorFile(), this.edit.getPythonNature(), this.edit, offset));
                }
                catch (BadLocationException e) {
                    PydevPlugin.log(e);
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
        Collections.sort(results, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        ICompletionProposal[] spellProps = null;
        IAnnotationModel annotationModel = this.edit.getPySourceViewer().getAnnotationModel();
        Iterator it = annotationModel.getAnnotationIterator();
        while (it.hasNext()) {
            Object annotation = it.next();
            if (!(annotation instanceof SpellingAnnotation)) continue;
            SpellingAnnotation spellingAnnotation = (SpellingAnnotation)annotation;
            SpellingProblem spellingProblem = spellingAnnotation.getSpellingProblem();
            int problemOffset = spellingProblem.getOffset();
            int problemLen = spellingProblem.getLength();
            if (problemOffset > offset || problemOffset + problemLen < offset) continue;
            SpellingCorrectionProcessor spellingCorrectionProcessor = new SpellingCorrectionProcessor();
            spellProps = spellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
            break;
        }
        if (spellProps == null || spellProps.length == 1 && spellProps[0] instanceof NoCompletionsProposal) {
            return results.toArray(new ICompletionProposal[results.size()]);
        }
        ICompletionProposal[] ret = results.toArray(new ICompletionProposal[results.size() + spellProps.length]);
        System.arraycopy(spellProps, 0, ret, results.size(), spellProps.length);
        return ret;
    }

    public String getErrorMessage() {
        return null;
    }
}

