/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.python.pydev.core.REF;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.plugin.PydevPlugin;

public class SourceModuleProposal
extends PyCompletionProposal {
    public final SourceModule module;
    public PyEdit edit;
    public IDocument doc;
    public Definition definition;
    public static final int ADD_TO_DEFAULT = -1;
    public static final int ADD_TO_LAST_LINE_BEFORE_MAIN = 0;
    public static final int ADD_TO_LAST_CLASS_LINE = 1;
    public int addTo = 0;

    public SourceModuleProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, SourceModule s, int priority) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority);
        this.module = s;
    }

    public void apply(IDocument dummy) {
        if (this.doc == null) {
            if (this.module.getFile() == null) {
                this.doc = dummy;
            } else {
                Path path = new Path(REF.getFileAbsolutePath((File)this.module.getFile()));
                IEditorPart part = PydevPlugin.doOpenEditor((IPath)path, true);
                if (part instanceof PyEdit) {
                    this.edit = (PyEdit)part;
                    this.doc = this.edit.getDocumentProvider().getDocument((Object)this.edit.getEditorInput());
                } else {
                    String contents = REF.getFileContents((File)this.module.getFile());
                    this.doc = new Document(contents);
                }
            }
        }
        this.fReplacementOffset = this.getReplacementOffset();
        super.apply(this.doc);
    }

    public int getReplacementOffset() {
        int i = -1;
        if (this.addTo == 0) {
            i = this.module.findIfMain() - 2;
        } else if (this.addTo == 1) {
            i = this.module.findAstEnd(this.definition.ast) - 2;
        }
        if (i < 0) {
            i = this.doc.getNumberOfLines();
        }
        try {
            IRegion lineInformation = this.doc.getLineInformation(i);
            return lineInformation.getOffset() + lineInformation.getLength();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return this.fReplacementOffset;
        }
    }

    public Point getSelection(IDocument dummy) {
        Point sel = super.getSelection(this.doc);
        if (this.module.getFile() == null) {
            return sel;
        }
        this.edit.setSelection(sel.x, sel.y);
        return null;
    }

    public String getReplacementStr() {
        return this.fReplacementString;
    }
}

