/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.PyCompletionPresentationUpdater;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.plugin.PydevPlugin;

public abstract class PyCompletionProposalExtension2
extends PyCompletionProposal
implements ICompletionProposalExtension2 {
    protected PyCompletionPresentationUpdater presentationUpdater = new PyCompletionPresentationUpdater();
    public int fLen;
    public boolean fLastIsPar;

    public PyCompletionProposalExtension2(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (smartToggle) {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int widgetCaret = text.getCaretOffset();
            IDocument document = viewer.getDocument();
            int finalOffset = widgetCaret;
            try {
                char c;
                if (finalOffset >= document.getLength()) {
                    this.unselected(viewer);
                    return;
                }
                while (this.isValidChar(c = document.getChar(finalOffset)) && ++finalOffset < document.getLength()) {
                }
                this.fLastIsPar = c == '(';
                if (!this.isValidChar(c)) {
                    --finalOffset;
                }
                this.fLen = finalOffset - widgetCaret;
                this.presentationUpdater.updateStyle(viewer, widgetCaret, this.fLen);
            }
            catch (BadLocationException e) {
                PydevPlugin.log(e);
            }
        } else {
            this.unselected(viewer);
        }
    }

    private boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public void unselected(ITextViewer viewer) {
        this.presentationUpdater.repairPresentation(viewer);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String[] strs = PySelection.getActivationTokenAndQual((IDocument)document, (int)offset, (boolean)false);
        String qualifier = strs[1].toLowerCase();
        if (strs[1].length() == 0 && (strs[0].length() == 0 || strs[0].endsWith("."))) {
            return false;
        }
        String displayString = this.getDisplayString().toLowerCase();
        return displayString.startsWith(qualifier);
    }
}

