/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyStringCodeCompletion;
import org.python.pydev.editor.codecompletion.revisited.ASTManager;
import org.python.pydev.editor.codecompletion.revisited.AssignAnalysis;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyCodeCompletion
extends AbstractPyCodeCompletion {
    public static volatile boolean DEBUG_CODE_COMPLETION = PyCodeCompletionPreferencesPage.isToDebugCodeCompletion();
    public static ICallback<Object, CompletionRecursionException> onCompletionRecursionException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException {
        ArrayList<ICompletionProposal> ret;
        block21: {
            if (request.getPySelection().getCursorLineContents().trim().startsWith("#")) {
                return new PyStringCodeCompletion().getCodeCompletionProposals(viewer, request);
            }
            if (DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"Starting getCodeCompletionProposals");
                Log.addLogLevel();
                Log.toLogFile((Object)this, (String)new StringBuffer("Request:").append(request).toString());
            }
            ret = new ArrayList<ICompletionProposal>();
            if (!this.isValidCompletionContext(request)) {
                request.showTemplates = false;
                return ret;
            }
            try {
                IPythonNature pythonNature = request.nature;
                this.checkPythonNature(pythonNature);
                ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                if (astManager == null) {
                    return ret;
                }
                ArrayList<Object> tokensList = new ArrayList<Object>();
                this.lazyStartShell(request);
                String trimmed = request.activationToken.replace('.', ' ').trim();
                ICodeCompletionASTManager.ImportInfo importsTipper = this.getImportsTipperStr(request);
                int line = request.doc.getLineOfOffset(request.documentOffset);
                IRegion region = request.doc.getLineInformation(line);
                CompletionState state = new CompletionState(line, request.documentOffset - region.getOffset(), null, request.nature, request.qualifier);
                state.setIsInCalltip(request.isInCalltip);
                boolean importsTip = false;
                if (importsTipper.importsTipperStr.length() != 0) {
                    request.isInCalltip = false;
                    importsTip = this.doImportCompletion(request, astManager, tokensList, importsTipper);
                } else if (trimmed.length() > 0 && request.activationToken.indexOf(46) != -1) {
                    this.doTokenCompletion(request, astManager, tokensList, trimmed, state);
                } else {
                    this.doGlobalsCompletion(request, astManager, tokensList, state);
                }
                HashMap<String, IToken> alreadyChecked = new HashMap<String, IToken>();
                String lowerCaseQual = request.qualifier.toLowerCase();
                if (lowerCaseQual.length() >= PyCodeCompletionPreferencesPage.getArgumentsDeepAnalysisNChars()) {
                    state.pushFindResolveImportMemoryCtx();
                    try {
                        ListIterator it = tokensList.listIterator();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!(o instanceof IToken)) continue;
                            it.remove();
                            IToken initialToken = (IToken)o;
                            IToken token = initialToken;
                            String strRep = token.getRepresentation();
                            IToken prev = (IToken)alreadyChecked.get(strRep);
                            if (prev != null && prev.getArgs().length() != 0 || !strRep.toLowerCase().startsWith(lowerCaseQual)) continue;
                            while (token.isImportFrom() && token.getArgs().length() <= 0) {
                                ICompletionState s = state.getCopyForResolveImportWithActTok(token.getRepresentation());
                                s.checkFindResolveImportMemory(token);
                                IToken token2 = astManager.resolveImport(s, token);
                                if (token2 == null || initialToken == token2) break;
                                String args = token2.getArgs();
                                if (args.length() > 0) {
                                    initialToken.setArgs(args);
                                    initialToken.setDocStr(token2.getDocStr());
                                    break;
                                }
                                if (token2 == null || token2.equals(token) && token2.getArgs().equals(token.getArgs()) && token2.getParentPackage().equals(token.getParentPackage())) {
                                    token2.equals(token);
                                    break;
                                }
                                token = token2;
                            }
                            alreadyChecked.put(strRep, initialToken);
                        }
                    }
                    finally {
                        state.popFindResolveImportMemoryCtx();
                    }
                }
                tokensList.addAll(alreadyChecked.values());
                this.changeItokenToCompletionPropostal(viewer, request, ret, tokensList, importsTip, state);
            }
            catch (CompletionRecursionException e) {
                if (onCompletionRecursionException != null) {
                    onCompletionRecursionException.call((Object)e);
                }
                if (!DEBUG_CODE_COMPLETION) break block21;
                Log.toLogFile((Exception)((Object)e));
            }
        }
        if (DEBUG_CODE_COMPLETION) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)new StringBuffer("Finished completion. Returned:").append(ret.size()).append(" completions.\r\n").toString());
        }
        return ret;
    }

    private boolean isValidCompletionContext(CompletionRequest request) {
        PySelection ps = request.getPySelection();
        return ps.isInDeclarationLine() == PySelection.DECLARATION_NONE;
    }

    private void doGlobalsCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, ICompletionState state) throws CompletionRecursionException {
        state.setActivationToken(request.activationToken);
        if (DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"astManager.getCompletionsForToken");
            Log.addLogLevel();
        }
        IToken[] comps = astManager.getCompletionsForToken(request.editorFile, request.doc, state);
        if (DEBUG_CODE_COMPLETION) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)"END astManager.getCompletionsForToken");
        }
        tokensList.addAll((Collection<Object>)Arrays.asList(comps));
        tokensList.addAll(this.getGlobalsFromParticipants(request, state));
    }

    private void doTokenCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, String trimmed, ICompletionState state) throws CompletionRecursionException {
        if (request.activationToken.endsWith(".")) {
            request.activationToken = request.activationToken.substring(0, request.activationToken.length() - 1);
        }
        char[] toks = new char[]{'.', ' '};
        ArrayList completions = new ArrayList();
        if (trimmed.equals("self") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("self")) {
            state.setLookingFor(1);
            PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false);
        } else if (trimmed.equals("cls") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("cls")) {
            state.setLookingFor(3);
            PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false);
        } else {
            state.setActivationToken(request.activationToken);
            IToken[] comps = astManager.getCompletionsForToken(request.editorFile, request.doc, state);
            tokensList.addAll((Collection<Object>)Arrays.asList(comps));
        }
        tokensList.addAll(completions);
    }

    private boolean doImportCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, ICodeCompletionASTManager.ImportInfo importsTipper) throws CompletionRecursionException {
        boolean importsTip = true;
        importsTipper.importsTipperStr = importsTipper.importsTipperStr.trim();
        IToken[] imports = astManager.getCompletionsForImport(importsTipper, (ICompletionRequest)request);
        tokensList.addAll((Collection<Object>)Arrays.asList(imports));
        return importsTip;
    }

    private void checkPythonNature(IPythonNature pythonNature) {
        if (pythonNature == null) {
            throw new RuntimeException("Unable to get python nature.");
        }
    }

    private void lazyStartShell(CompletionRequest request) {
        try {
            if (DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"AbstractShell.getServerShell");
            }
            if (CompiledModule.COMPILED_MODULES_ENABLED) {
                AbstractShell.getServerShell(request.nature, 1);
            }
            if (DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"END AbstractShell.getServerShell");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<Object> getGlobalsFromParticipants(CompletionRequest request, ICompletionState state) {
        ArrayList<Object> ret = new ArrayList<Object>();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
        for (IPyDevCompletionParticipant participant : participants) {
            ret.addAll(participant.getGlobalCompletions(request, state));
        }
        return ret;
    }

    public static void getSelfOrClsCompletions(CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers) {
        SimpleNode s = (SimpleNode)PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo((IDocument)request.doc, (boolean)true, (IPythonNature)request.nature, (int)state.getLine())).o1;
        PyCodeCompletion.getSelfOrClsCompletions(request, theList, state, getOnlySupers, s);
    }

    public static void getSelfOrClsCompletions(CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers, SimpleNode s) {
        if (s != null) {
            FindScopeVisitor visitor = new FindScopeVisitor(state.getLine(), 0);
            try {
                s.accept((VisitorIF)visitor);
                PyCodeCompletion.getSelfOrClsCompletions(visitor.scope, request, theList, state, getOnlySupers);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void getSelfOrClsCompletions(ILocalScope scope, CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers) throws BadLocationException {
        for (SimpleNode node : scope) {
            String resolveModule;
            if (!(node instanceof ClassDef)) continue;
            ClassDef d = (ClassDef)node;
            if (getOnlySupers) {
                ArrayList gottenComps = new ArrayList();
                int i = 0;
                while (i < d.bases.length) {
                    if (d.bases[i] instanceof Name) {
                        Name n = (Name)d.bases[i];
                        state.setActivationToken(n.id);
                        try {
                            IToken[] completions = request.nature.getAstManager().getCompletionsForToken(request.editorFile, request.doc, state);
                            gottenComps.addAll(Arrays.asList(completions));
                        }
                        catch (CompletionRecursionException completionRecursionException) {}
                    }
                    ++i;
                }
                theList.addAll(gottenComps);
                continue;
            }
            String trimmed = request.activationToken.replace('.', ' ').trim();
            String[] actTokStrs = trimmed.split(" ");
            if (actTokStrs.length == 0 || !actTokStrs[0].equals("self") && !actTokStrs[0].equals("cls")) {
                throw new AssertionError((Object)"We need to have at least one token (self or cls) for doing completions in the class.");
            }
            if (actTokStrs.length == 1) {
                state.setActivationToken(NodeUtils.getNameFromNameTok((NameTok)((NameTok)d.name)));
                try {
                    theList.addAll((Collection)Arrays.asList(request.nature.getAstManager().getCompletionsForToken(request.editorFile, request.doc, state)));
                }
                catch (CompletionRecursionException completionRecursionException) {}
                continue;
            }
            int line = request.doc.getLineOfOffset(request.documentOffset);
            IRegion region = request.doc.getLineInformationOfOffset(request.documentOffset);
            int col = request.documentOffset - region.getOffset();
            String modName = "";
            File requestFile = request.editorFile;
            if (request.editorFile != null && (resolveModule = request.nature.resolveModule(requestFile)) != null) {
                modName = resolveModule;
            }
            AbstractModule module = AbstractModule.createModuleFromDoc(modName, requestFile, request.doc, request.nature, line);
            ASTManager astMan = (ASTManager)request.nature.getAstManager();
            theList.addAll(new AssignAnalysis().getAssignCompletions(astMan, module, new CompletionState(line, col, request.activationToken, request.nature, request.qualifier)));
        }
    }
}

