/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.prettyprinter.IFormatter;
import org.python.pydev.plugin.PyCodeFormatterPage;

public class PyFormatStd
extends PyAction
implements IFormatter {
    public void run(IAction action) {
        try {
            IFormatter participant = (IFormatter)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_formatter");
            if (participant == null) {
                participant = this;
            }
            PySelection ps = new PySelection(this.getTextEditor());
            IDocument doc = ps.getDoc();
            int startLine = ps.getStartLineIndex();
            PyEdit pyEdit = this.getPyEdit();
            if (ps.getTextSelection().getLength() == 0) {
                participant.formatAll(doc, (IPyEdit)pyEdit);
            } else {
                participant.formatSelection(doc, startLine, ps.getEndLineIndex(), (IPyEdit)pyEdit, ps);
            }
            if (startLine >= doc.getNumberOfLines()) {
                startLine = doc.getNumberOfLines() - 1;
            }
            TextSelection sel = new TextSelection(doc, doc.getLineOffset(startLine), 0);
            this.getTextEditor().getSelectionProvider().setSelection((ISelection)sel);
        }
        catch (Exception e) {
            PyFormatStd.beep(e);
        }
    }

    public void formatSelection(IDocument doc, int startLine, int endLineIndex, IPyEdit edit, PySelection ps) {
        this.performFormatSelection(doc, startLine, endLineIndex);
    }

    public void formatAll(IDocument doc, IPyEdit edit) {
        this.performFormatAll(doc);
    }

    public void performFormatSelection(IDocument doc, int startLineIndex, int endLineIndex) {
        try {
            IRegion start = doc.getLineInformation(startLineIndex);
            IRegion end = doc.getLineInformation(endLineIndex);
            int iStart = start.getOffset();
            int iEnd = end.getOffset() + end.getLength();
            String d = doc.get(iStart, iEnd - iStart);
            FormatStd formatStd = this.getFormat();
            String formatted = PyFormatStd.formatStr(d, formatStd);
            doc.replace(iStart, iEnd - iStart, formatted);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private FormatStd getFormat() {
        FormatStd formatStd = new FormatStd();
        formatStd.parametersWithSpace = PyCodeFormatterPage.useSpaceForParentesis();
        formatStd.spaceAfterComma = PyCodeFormatterPage.useSpaceAfterComma();
        return formatStd;
    }

    public void performFormatAll(IDocument doc) {
        String d = doc.get();
        FormatStd formatStd = this.getFormat();
        String formatted = PyFormatStd.formatStr(d, formatStd);
        doc.set(formatted);
    }

    public static String formatStr(String str, FormatStd std) {
        char[] cs = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        char lastChar = '\u0000';
        int i = 0;
        while (i < cs.length) {
            char c = cs[i];
            if (c == '\'' || c == '\"') {
                i = ParsingUtils.eatLiterals((Object)cs, (StringBuffer)buf, (int)i);
            } else if (c == '#') {
                i = ParsingUtils.eatComments((Object)cs, (StringBuffer)buf, (int)i);
            } else if (c == ',') {
                i = PyFormatStd.formatForComma(std, cs, buf, i);
            } else if (c == '(') {
                i = PyFormatStd.formatForPar(cs, i, std, buf);
            } else {
                if ((c == '\r' || c == '\n') && lastChar == ',' && std.spaceAfterComma) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                buf.append(c);
            }
            lastChar = c;
            ++i;
        }
        return buf.toString();
    }

    private static int formatForPar(char[] cs, int i, FormatStd std, StringBuffer buf) {
        char c = ' ';
        StringBuffer locBuf = new StringBuffer();
        int j = i + 1;
        while (j < cs.length && (c = cs[j]) != ')') {
            ++j;
            if (c == '\'' || c == '\"') {
                j = ParsingUtils.eatLiterals((Object)cs, (StringBuffer)locBuf, (int)(j - 1)) + 1;
                continue;
            }
            if (c == '#') {
                j = ParsingUtils.eatComments((Object)cs, (StringBuffer)locBuf, (int)(j - 1)) + 1;
                continue;
            }
            if (c == '(') {
                j = PyFormatStd.formatForPar(cs, j - 1, std, locBuf) + 1;
                continue;
            }
            locBuf.append(c);
        }
        if (c == ')') {
            StringBuffer buf1 = new StringBuffer();
            if (locBuf.indexOf("\n") != -1) {
                char c1;
                int k = locBuf.length();
                while (k > 0 && (c1 = locBuf.charAt(k - 1)) != '\n') {
                    buf1.insert(0, c1);
                    --k;
                }
            }
            String formatStr = PyFormatStd.formatStr(PyFormatStd.trim(locBuf), std);
            formatStr = PyFormatStd.trim(new StringBuffer(formatStr));
            String closing = ")";
            if (buf1.length() > 0 && PySelection.containsOnlyWhitespaces((String)buf1.toString())) {
                formatStr = String.valueOf(formatStr) + buf1.toString();
            } else if (std.parametersWithSpace) {
                closing = " )";
            }
            if (std.parametersWithSpace) {
                if (formatStr.length() == 0) {
                    buf.append("()");
                } else {
                    buf.append("( ");
                    buf.append(formatStr);
                    buf.append(closing);
                }
            } else {
                buf.append("(");
                buf.append(formatStr);
                buf.append(closing);
            }
            return j;
        }
        return i;
    }

    private static String trim(StringBuffer locBuf) {
        while (locBuf.length() > 0 && locBuf.charAt(0) == ' ') {
            locBuf.deleteCharAt(0);
        }
        while (locBuf.length() > 0 && locBuf.charAt(locBuf.length() - 1) == ' ') {
            locBuf.deleteCharAt(locBuf.length() - 1);
        }
        return locBuf.toString();
    }

    private static int formatForComma(FormatStd std, char[] cs, StringBuffer buf, int i) {
        while (i < cs.length - 1 && cs[i + 1] == ' ') {
            ++i;
        }
        if (std.spaceAfterComma) {
            buf.append(", ");
        } else {
            buf.append(',');
        }
        return i;
    }

    public static class FormatStd {
        public boolean spaceAfterComma;
        public boolean parametersWithSpace;
    }
}

