/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.PyConvertSpaceToTab;

public class PyConvertTabToSpace
extends PyConvertSpaceToTab {
    private static PySelection ps;

    public void run(IAction action) {
        try {
            ps = new PySelection(this.getTextEditor());
            ps.selectAll(false);
            PyConvertTabToSpace.perform();
            this.getTextEditor().selectAndReveal(ps.getLineOffset(), 0);
        }
        catch (Exception e) {
            PyConvertTabToSpace.beep(e);
        }
    }

    public static boolean perform() {
        return PyConvertTabToSpace.perform(ps);
    }

    public static boolean perform(PySelection ps) {
        StringBuffer strbuf = new StringBuffer();
        ps.selectCompleteLine();
        try {
            int i = ps.getStartLineIndex();
            while (i <= ps.getEndLineIndex()) {
                String line = ps.getDoc().get(ps.getDoc().getLineInformation(i).getOffset(), ps.getDoc().getLineInformation(i).getLength());
                strbuf.append(String.valueOf(line.replaceAll("\t", PyConvertTabToSpace.getTabSpace())) + (i < ps.getEndLineIndex() ? ps.getEndLineDelim() : ""));
                ++i;
            }
            if (strbuf.toString() != null) {
                ps.getDoc().replace(ps.getStartLine().getOffset(), ps.getSelLength(), strbuf.toString());
                return true;
            }
        }
        catch (Exception e) {
            PyConvertTabToSpace.beep(e);
        }
        return false;
    }
}

