/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pylint;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PydevMarkerUtils;
import org.python.pydev.builder.pylint.PyLintPrefPage;
import org.python.pydev.core.REF;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimplePythonRunner;

public class PyLintVisitor
extends PyDevBuilderVisitor {
    public static final String PYLINT_PROBLEM_MARKER = "org.python.pydev.pylintproblemmarker";
    public static final List<PyLintThread> pyLintThreads = new ArrayList<PyLintThread>();
    private static MessageConsole fConsole;

    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        IFile file;
        IPath location;
        if (document == null) {
            return;
        }
        if (!PyLintPrefPage.usePyLint()) {
            try {
                resource.deleteMarkers(PYLINT_PROBLEM_MARKER, false, 0);
            }
            catch (CoreException e3) {
                PydevPlugin.log(e3);
            }
            return;
        }
        IProject project = resource.getProject();
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        try {
            if (!pythonNature.isPython()) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (project != null && resource instanceof IFile && (location = (file = (IFile)resource).getRawLocation()) != null) {
            PyLintThread thread = new PyLintThread(resource, document, location);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String cmdLineToExe, IOConsoleOutputStream out) {
        block5: {
            try {
                if (fConsole == null || out == null) break block5;
                MessageConsole messageConsole = fConsole;
                synchronized (messageConsole) {
                    out.write(cmdLineToExe);
                }
            }
            catch (IOException e) {
                PydevPlugin.log(e);
            }
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
    }

    public int maxResourcesToVisit() {
        int i = PyLintPrefPage.getMaxPyLintDelta();
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    public static class PyLintThread
    extends Thread {
        IResource resource;
        IDocument document;
        IPath location;
        List<Object[]> markers = new ArrayList<Object[]>();

        public PyLintThread(IResource resource, IDocument document, IPath location) {
            this.setName("PyLint thread");
            this.resource = resource;
            this.document = document;
            this.location = location;
        }

        private boolean canPassPyLint() {
            if (pyLintThreads.size() < PyLintPrefPage.getMaxPyLintDelta()) {
                pyLintThreads.add(this);
                return true;
            }
            return false;
        }

        public void run() {
            block14: {
                try {
                    try {
                        if (!this.canPassPyLint()) break block14;
                        IOConsoleOutputStream out = null;
                        try {
                            MessageConsole console = this.getConsole();
                            if (console != null) {
                                out = console.newOutputStream();
                            }
                        }
                        catch (MalformedURLException e3) {
                            throw new RuntimeException(e3);
                        }
                        this.passPyLint(this.resource, out);
                        new Job("Adding markers"){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    PyLintThread.this.resource.deleteMarkers(PyLintVisitor.PYLINT_PROBLEM_MARKER, false, 0);
                                }
                                catch (CoreException e3) {
                                    PydevPlugin.log(e3);
                                }
                                Iterator<Object[]> iter = PyLintThread.this.markers.iterator();
                                while (iter.hasNext()) {
                                    Object[] el = iter.next();
                                    String tok = (String)el[0];
                                    String type = (String)el[1];
                                    int priority = (Integer)el[2];
                                    String id = (String)el[3];
                                    int line = (Integer)el[4];
                                    try {
                                        PydevMarkerUtils.createMarker(PyLintThread.this.resource, PyLintThread.this.document, "ID:" + id + " " + tok, line, 0, line, 0, type, priority);
                                    }
                                    catch (BadLocationException badLocationException) {}
                                }
                                return PydevPlugin.makeStatus(0, "", null);
                            }
                        }.schedule();
                    }
                    catch (CoreException e) {
                        new Job("Error reporting"){

                            protected IStatus run(IProgressMonitor monitor) {
                                PydevPlugin.log(e);
                                return PydevPlugin.makeStatus(0, "", null);
                            }
                        }.schedule();
                        try {
                            pyLintThreads.remove(this);
                        }
                        catch (Exception e2) {
                            PydevPlugin.log(e2);
                        }
                    }
                }
                finally {
                    try {
                        pyLintThreads.remove(this);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                }
            }
        }

        private MessageConsole getConsole() throws MalformedURLException {
            if (PyLintPrefPage.useConsole()) {
                if (fConsole == null) {
                    fConsole = new MessageConsole("", PydevPlugin.getImageCache().getDescriptor("icons/python.gif"));
                    ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
                }
            } else {
                return null;
            }
            return fConsole;
        }

        private void addToMarkers(String tok, String type, int priority, String id, int line) {
            this.markers.add(new Object[]{tok, type, Autobox.valueOf((int)priority), id, Autobox.valueOf((int)line)});
        }

        /*
         * Unable to fully structure code
         */
        private void passPyLint(IResource resource, IOConsoleOutputStream out) throws CoreException {
            script = new File(PyLintPrefPage.getPyLintLocation());
            arg = new File(this.location.toOSString());
            list = new ArrayList<String>();
            list.add("--include-ids=y");
            userArgs = PyLintPrefPage.getPylintArgs().replaceAll("\r", "").replaceAll("\n", " ");
            tokenizer2 = new StringTokenizer(userArgs);
            while (tokenizer2.hasMoreTokens()) {
                list.add(tokenizer2.nextToken());
            }
            list.add(REF.getFileAbsolutePath((File)arg));
            project = resource.getProject();
            scriptToExe = REF.getFileAbsolutePath((File)script);
            paramsToExe = list.toArray(new String[0]);
            cmdLineToExe = SimplePythonRunner.makeExecutableCommandStr(scriptToExe, paramsToExe);
            PyLintVisitor.write("Pylint: Executing command line:'" + cmdLineToExe + "'", out);
            outTup = new SimplePythonRunner().runAndGetOutput(cmdLineToExe, arg.getParentFile(), project);
            PyLintVisitor.write("Pylint: The stdout of the command line is: " + (String)outTup.o1, out);
            PyLintVisitor.write("Pylint: The stderr of the command line is: " + (String)outTup.o2, out);
            output = (String)outTup.o1;
            tokenizer = new StringTokenizer(output, "\r\n");
            useW = PyLintPrefPage.useWarnings();
            useE = PyLintPrefPage.useErrors();
            useF = PyLintPrefPage.useFatal();
            useC = PyLintPrefPage.useCodingStandard();
            useR = PyLintPrefPage.useRefactorTips();
            wSeverity = PyLintPrefPage.wSeverity();
            eSeverity = PyLintPrefPage.eSeverity();
            fSeverity = PyLintPrefPage.fSeverity();
            cSeverity = PyLintPrefPage.cSeverity();
            rSeverity = PyLintPrefPage.rSeverity();
            if (output.indexOf("Traceback (most recent call last):") != -1) {
                PydevPlugin.log(new RuntimeException("PyLint ERROR: \n" + output));
                return;
            }
            if (((String)outTup.o2).indexOf("Traceback (most recent call last):") == -1) ** GOTO lbl89
            PydevPlugin.log(new RuntimeException("PyLint ERROR: \n" + (String)outTup.o2));
            return;
lbl-1000:
            // 1 sources

            {
                tok = tokenizer.nextToken();
                try {
                    type = null;
                    priority = 0;
                    indexOfDoublePoints = tok.indexOf(":");
                    if (indexOfDoublePoints == -1) continue;
                    if (tok.startsWith("C") && useC) {
                        type = "org.python.pydev.pylintproblemmarker";
                        priority = cSeverity;
                    } else if (tok.startsWith("R") && useR) {
                        type = "org.python.pydev.pylintproblemmarker";
                        priority = rSeverity;
                    } else if (tok.startsWith("W") && useW) {
                        type = "org.python.pydev.pylintproblemmarker";
                        priority = wSeverity;
                    } else if (tok.startsWith("E") && useE) {
                        type = "org.python.pydev.pylintproblemmarker";
                        priority = eSeverity;
                    } else {
                        if (!tok.startsWith("F") || !useF) continue;
                        type = "org.python.pydev.pylintproblemmarker";
                        priority = fSeverity;
                    }
                    try {
                        if (type == null) continue;
                        id = tok.substring(0, tok.indexOf(":")).trim();
                        i = tok.indexOf(":");
                        if (i == -1 || (i = (tok = tok.substring(i + 1)).indexOf(":")) == -1) continue;
                        line = Integer.parseInt(tok.substring(0, i).trim());
                        region = null;
                        try {
                            region = this.document.getLineInformation(line - 1);
                        }
                        catch (Exception v0) {
                            region = this.document.getLineInformation(line);
                        }
                        lineContents = this.document.get(region.getOffset(), region.getLength());
                        pos = -1;
                        pos = lineContents.indexOf("IGNORE:");
                        if (pos != -1 && (lintW = lineContents.substring(pos + "IGNORE:".length())).startsWith(id) || (i = tok.indexOf(":")) == -1) continue;
                        tok = tok.substring(i + 1);
                        this.addToMarkers(tok, type, priority, id, line - 1);
                    }
                    catch (RuntimeException e2) {
                        PydevPlugin.log(e2);
                    }
                    continue;
                }
                catch (Exception e1) {
                    PydevPlugin.log(e1);
                }
lbl89:
                // 9 sources

                ** while (tokenizer.hasMoreTokens())
            }
lbl90:
            // 1 sources

        }
    }
}

