/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevMarkerUtils {
    public static IMarker markerExists(IResource resource, String message, int charStart, int charEnd, String type) {
        return PydevMarkerUtils.markerExists(resource, message, charStart, charEnd, type, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMarker markerExists(IResource resource, String message, int charStart, int charEnd, String type, List<IMarker> existingMarkers) {
        existingMarkers = PydevMarkerUtils.checkExistingMarkers(resource, type, existingMarkers);
        try {
            IMarker task;
            boolean eqCharEnd;
            boolean eqCharStart;
            boolean eqMessage;
            Iterator<IMarker> iterator = existingMarkers.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                task = iterator.next();
                Object msg = task.getAttribute("message");
                Object start = task.getAttribute("charStart");
                Object end = task.getAttribute("charEnd");
                if (msg == null) return null;
                if (start == null) return null;
                if (end == null) return null;
                if (message == null) {
                    return null;
                }
                eqMessage = msg.equals(message);
                eqCharStart = (Integer)start == charStart;
                boolean bl = eqCharEnd = (Integer)end == charEnd;
            } while (!eqMessage || !eqCharStart || !eqCharEnd);
            return task;
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        return null;
    }

    public static IMarker markerExists(IResource resource, String message, int lineNumber, String type) {
        return PydevMarkerUtils.markerExists(resource, message, lineNumber, lineNumber, type, null);
    }

    public static IMarker markerExists(IResource resource, String message, int lineNumber, String type, List<IMarker> existingMarkers) {
        existingMarkers = PydevMarkerUtils.checkExistingMarkers(resource, type, existingMarkers);
        try {
            for (IMarker task : existingMarkers) {
                boolean eqLineNumber = (Integer)task.getAttribute("lineNumber") == lineNumber;
                boolean eqMessage = task.getAttribute("message").equals(message);
                if (!eqLineNumber || !eqMessage) continue;
                return task;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void createMarker(IResource resource, IDocument doc, String message, int lineStart, int colStart, int lineEnd, int colEnd, String markerType, int severity) throws BadLocationException {
        PydevMarkerUtils.createMarker(resource, doc, message, lineStart, colStart, lineEnd, colEnd, markerType, severity, null);
    }

    public static IMarker createMarker(IResource resource, IDocument doc, String message, int lineStart, int colStart, int lineEnd, int colEnd, String markerType, int severity, Map<String, Object> additionalInfo) throws BadLocationException {
        return PydevMarkerUtils.createMarker(resource, doc, message, lineStart, colStart, lineEnd, colEnd, markerType, severity, additionalInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMarker createMarker(IResource resource, IDocument doc, String message, int lineStart, int colStart, int lineEnd, int colEnd, String markerType, int severity, Map<String, Object> additionalInfo, List<IMarker> existingMarkers) throws BadLocationException {
        IResource iResource = resource;
        synchronized (iResource) {
            int endAbsolute;
            int startAbsolute;
            existingMarkers = PydevMarkerUtils.checkExistingMarkers(resource, markerType, existingMarkers);
            if (lineStart < 0) {
                lineStart = 0;
            }
            try {
                IRegion start = doc.getLineInformation(lineStart);
                startAbsolute = start.getOffset() + colStart;
                if (lineEnd >= 0 && colEnd >= 0) {
                    IRegion end = doc.getLineInformation(lineEnd);
                    endAbsolute = end.getOffset() + colEnd;
                } else {
                    String line = doc.get(start.getOffset(), start.getLength());
                    int i = line.indexOf(35);
                    StringBuffer buffer = i != -1 ? new StringBuffer(line.substring(0, i)) : new StringBuffer(line);
                    while (buffer.length() > 0 && Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                    endAbsolute = start.getOffset() + buffer.length();
                }
            }
            catch (BadLocationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            IMarker marker = PydevMarkerUtils.markerExists(resource, message, startAbsolute, endAbsolute, markerType, existingMarkers);
            if (marker == null) {
                try {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("message", message);
                    map.put("lineNumber", Autobox.valueOf((int)lineStart));
                    map.put("charStart", Autobox.valueOf((int)startAbsolute));
                    map.put("charEnd", Autobox.valueOf((int)endAbsolute));
                    map.put("severity", Autobox.valueOf((int)severity));
                    if (additionalInfo != null) {
                        for (Map.Entry<String, Object> entry : additionalInfo.entrySet()) {
                            map.put(entry.getKey(), entry.getValue());
                        }
                    }
                    MarkerUtilities.createMarker((IResource)resource, map, (String)markerType);
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            } else {
                try {
                    Object mS;
                    Object lN = marker.getAttribute("lineNumber");
                    if (lN == null || (Integer)lN != lineStart) {
                        marker.setAttribute("lineNumber", (Object)new Integer(lineStart));
                    }
                    if ((mS = marker.getAttribute("severity")) == null || (Integer)mS != severity) {
                        marker.setAttribute("severity", severity);
                    }
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
                existingMarkers.remove(marker);
            }
            return marker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IMarker> checkExistingMarkers(IResource resource, String markerType, List<IMarker> existingMarkers) {
        IResource iResource = resource;
        synchronized (iResource) {
            if (existingMarkers == null) {
                try {
                    IMarker[] markers;
                    existingMarkers = new ArrayList<IMarker>();
                    IMarker[] iMarkerArray = markers = resource.findMarkers(markerType, true, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        existingMarkers.add(marker);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    existingMarkers = new ArrayList<IMarker>();
                    PydevPlugin.log(e);
                }
            }
            return existingMarkers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMarker createMarker(IResource resource, IDocument doc, String message, int lineNumber, String markerType, int severity, boolean userEditable, boolean istransient, List<IMarker> existingMarkers) throws BadLocationException {
        IResource iResource = resource;
        synchronized (iResource) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userEditable", Autobox.valueOf((boolean)userEditable));
            map.put("transient", Autobox.valueOf((boolean)istransient));
            return PydevMarkerUtils.createMarker(resource, doc, message, lineNumber, 0, lineNumber, 0, markerType, severity, map, existingMarkers);
        }
    }
}

